/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.entity.EntityPlaneWheelBase;
import de.maxhenkel.plane.sound.ModSounds;
import de.maxhenkel.plane.sound.SoundLoopHigh;
import de.maxhenkel.plane.sound.SoundLoopIdle;
import de.maxhenkel.plane.sound.SoundLoopStart;
import de.maxhenkel.plane.sound.SoundLoopStarting;
import de.maxhenkel.plane.sound.SoundLoopStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityPlaneSoundBase
extends EntityPlaneWheelBase {
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStart startLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopIdle idleLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopHigh highLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStarting startingLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStop stopLoop;
    private int ticksSinceStarted = 0;

    public EntityPlaneSoundBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.updateSounds();
        }
    }

    private void updateSounds() {
        if (this.isStarted()) {
            if (this.ticksSinceStarted >= 20) {
                if (this.getEngineSpeed() <= 0.0f) {
                    this.checkIdleLoop();
                } else {
                    this.checkHighLoop();
                }
            } else {
                ++this.ticksSinceStarted;
            }
        } else {
            this.ticksSinceStarted = 0;
        }
        if (this.getStartTime() > 0) {
            this.checkStartingLoop();
        }
    }

    @Override
    public void setStarted(boolean started) {
        this.setStarted(started, true);
    }

    public void setStarted(boolean started, boolean playSound) {
        super.setStarted(started);
        if (this.f_19853_.f_46443_ && playSound) {
            if (!started) {
                this.checkStopLoop();
            } else {
                this.checkStartLoop();
            }
        }
    }

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        ModSounds.playSound((SoundEvent)ModSounds.CRASH.get(), this.f_19853_, this.m_20183_(), null, SoundSource.NEUTRAL, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkIdleLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this, (SoundEvent)ModSounds.ENGINE_IDLE.get(), SoundSource.NEUTRAL);
            ModSounds.playSoundLoop(this.idleLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkHighLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this, (SoundEvent)ModSounds.ENGINE_HIGH.get(), SoundSource.NEUTRAL);
            ModSounds.playSoundLoop(this.highLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this, (SoundEvent)ModSounds.ENGINE_START.get(), SoundSource.NEUTRAL);
            ModSounds.playSoundLoop(this.startLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStopLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.stopLoop)) {
            this.stopLoop = new SoundLoopStop(this, (SoundEvent)ModSounds.ENGINE_STOP.get(), SoundSource.NEUTRAL);
            ModSounds.playSoundLoop(this.stopLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartingLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this, (SoundEvent)ModSounds.ENGINE_STARTING.get(), SoundSource.NEUTRAL);
            ModSounds.playSoundLoop(this.startingLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.m_91087_().m_91106_().m_120403_(sound);
    }
}

