/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.item;

import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneFuelBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ItemAbstractPlane<T extends EntityPlaneSoundBase>
extends Item {
    public ItemAbstractPlane() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_));
    }

    public abstract T createPlane(Level var1);

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        if (!context.m_43719_().equals((Object)Direction.UP)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        if (!world.m_8055_((pos = context.m_8083_()).m_7494_()).m_60812_((BlockGetter)world, pos).m_83281_()) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        T plane = this.createPlane(world);
        ((EntityPlaneFuelBase)((Object)plane)).setFuel(500);
        BlockState state = world.m_8055_(pos);
        VoxelShape collisionShape = state.m_60812_((BlockGetter)world, pos);
        plane.m_19890_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + (collisionShape.m_83281_() ? 0.0 : state.m_60812_((BlockGetter)world, (BlockPos)pos).m_83215_().f_82292_) + 0.01, (double)pos.m_123343_() + 0.5, context.m_43723_().m_146908_(), 0.0f);
        this.addData(context.m_43722_(), (EntityPlaneSoundBase)((Object)plane));
        world.m_7967_(plane);
        if (!player.m_150110_().f_35937_) {
            context.m_43722_().m_41764_(context.m_43722_().m_41613_() - 1);
        }
        return InteractionResult.SUCCESS;
    }

    private void addData(ItemStack stack, EntityPlaneSoundBase plane) {
        CompoundTag planeData = this.getPlaneData(stack);
        if (planeData != null) {
            plane.m_7378_(planeData);
            plane.setStarted(false, false);
        }
        if (!stack.m_41720_().m_7626_(stack).equals(stack.m_41786_())) {
            plane.m_6593_(stack.m_41786_());
        }
    }

    private CompoundTag getPlaneData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        if (!tag.m_128441_("PlaneData")) {
            return null;
        }
        return tag.m_128469_("PlaneData");
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag planeData = this.getPlaneData(stack);
        if (planeData != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.plane.damage", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(MathUtils.round(planeData.m_128457_("Damage"), 2))).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.plane.fuel", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(planeData.m_128451_("Fuel"))).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

