/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.terraform.boat.item;

import de.cristelknight.doapi.terraform.boat.item.TerraformBoatDispenserBehavior;
import de.cristelknight.doapi.terraform.boat.item.TerraformBoatItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;

public final class TerraformBoatItemHelper {
    private static final CreativeModeTab DEFAULT_ITEM_GROUP = CreativeModeTab.f_40752_;
    private static final Map<RegistrySupplier<? extends ItemLike>, TerraformBoatDispenserBehavior> DISPENSER_BEHAVIOURS = new HashMap<RegistrySupplier<? extends ItemLike>, TerraformBoatDispenserBehavior>();

    private TerraformBoatItemHelper() {
    }

    public static RegistrySupplier<Item> registerBoatItem(DeferredRegister<Item> register, String name, ResourceLocation boatTypeName, boolean chest) {
        return TerraformBoatItemHelper.registerBoatItem(register, name, boatTypeName, chest, DEFAULT_ITEM_GROUP);
    }

    public static RegistrySupplier<Item> registerBoatItem(DeferredRegister<Item> register, String name, ResourceLocation boatTypeName, boolean chest, CreativeModeTab group) {
        return TerraformBoatItemHelper.registerBoatItem(register, name, boatTypeName, chest, new Item.Properties().m_41487_(1).m_41491_(group));
    }

    public static RegistrySupplier<Item> registerBoatItem(DeferredRegister<Item> register, String name, ResourceLocation boatTypeName, boolean chest, Item.Properties settings) {
        RegistrySupplier item = register.register(name, () -> new TerraformBoatItem(boatTypeName, chest, settings));
        TerraformBoatItemHelper.registerBoatDispenserBehavior(item, boatTypeName, chest);
        return item;
    }

    public static <T extends ItemLike> void registerBoatDispenserBehavior(RegistrySupplier<T> item, ResourceLocation boatTypeName, boolean chest) {
        DISPENSER_BEHAVIOURS.put(item, new TerraformBoatDispenserBehavior(boatTypeName, chest));
    }

    public static void registerDispenserBehaviours() {
        DISPENSER_BEHAVIOURS.forEach((item, dispenserBehavior) -> DispenserBlock.m_52672_((ItemLike)((ItemLike)item.get()), (DispenseItemBehavior)dispenserBehavior));
    }
}

