/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypesAndSizeContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModResources;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityButterfly
extends EntityAnimalWithTypesAndSizeContainable {
    private static final EntityDataAccessor<Boolean> HAS_NECTAR = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LANDED = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TargetingConditions playerPredicate = TargetingConditions.m_148353_().m_26883_(4.0).m_148355_();
    private BlockPos targetPosition;
    private int rainTicks = 0;
    private int ticksUntilNextGrow = 0;

    public EntityButterfly(EntityType<? extends EntityButterfly> entityType, Level worldIn) {
        super((EntityType<? extends EntityAnimalWithTypesAndSizeContainable>)entityType, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LANDED, (Object)1);
        this.f_19804_.m_135372_(HAS_NECTAR, (Object)false);
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19325_;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public boolean isLanded() {
        return (Integer)this.f_19804_.m_135370_(LANDED) != 1;
    }

    public int getLandedInteger() {
        return (Integer)this.f_19804_.m_135370_(LANDED);
    }

    public void setLanded(Direction direction) {
        if (direction == Direction.UP) {
            throw new RuntimeException("Invalid landing direction!");
        }
        this.f_19804_.m_135381_(LANDED, (Object)direction.ordinal());
    }

    public void setNotLanded() {
        this.f_19804_.m_135381_(LANDED, (Object)1);
        this.m_6021_((double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5);
    }

    public boolean hasNectar() {
        return (Boolean)this.f_19804_.m_135370_(HAS_NECTAR);
    }

    public void setHasNectar(boolean value) {
        this.f_19804_.m_135381_(HAS_NECTAR, (Object)value);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isLanded()) {
            this.m_20256_(Vec3.f_82478_);
            if (Direction.m_122376_((int)this.getLandedInteger()) != Direction.DOWN) {
                double x = Math.floor(this.m_20185_()) + 0.5;
                double z = Math.floor(this.m_20189_()) + 0.5;
                BlockPos pos = new BlockPos(x, Math.floor(this.m_20186_()) + 0.5, z);
                BlockPos offset = pos.m_121945_(Direction.m_122376_((int)this.getLandedInteger()));
                BlockPos diff = pos.m_121996_((Vec3i)offset);
                this.m_6021_(x - (double)diff.m_123341_() / 2.778, Math.floor(this.m_20186_()) + 0.5, z - (double)diff.m_123343_() / 2.778);
                this.m_146922_(0.0f);
                this.f_20885_ = 0.0f;
            } else {
                this.m_6021_(this.m_20185_(), Math.floor(this.m_20186_()), this.m_20189_());
            }
        } else {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.hasNectar() && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                EntityButterfly.addParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20186_() + 0.5, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()));
            }
        }
    }

    private static void addParticle(Level worldIn, double xStart, double xEnd, double zStart, double zEnd, double posY, ParticleOptions particleData) {
        worldIn.m_7106_(particleData, Mth.m_14139_((double)worldIn.f_46441_.m_188500_(), (double)xStart, (double)xEnd), posY, Mth.m_14139_((double)worldIn.f_46441_.m_188500_(), (double)zStart, (double)zEnd), 0.0, 0.0, 0.0);
    }

    public boolean isRainingAt(BlockPos position) {
        if (!this.f_19853_.m_46471_()) {
            return false;
        }
        if (position == null) {
            return true;
        }
        if (!this.f_19853_.m_46749_(position) || !this.f_19853_.m_46861_(position)) {
            return false;
        }
        return ((Biome)this.f_19853_.m_204166_(position).m_203334_()).m_47530_() == Biome.Precipitation.RAIN;
    }

    protected void m_8024_() {
        super.m_8024_();
        BlockPos blockpos = this.m_20183_();
        if (this.isLanded()) {
            Direction direction = Direction.m_122376_((int)this.getLandedInteger());
            Direction[] offset = blockpos.m_121945_(direction);
            if (this.f_19853_.m_8055_((BlockPos)offset).m_60659_((BlockGetter)this.f_19853_, (BlockPos)offset, direction.m_122424_(), SupportType.CENTER)) {
                if (this.f_19853_.m_45946_(playerPredicate, (LivingEntity)this) != null || this.m_217043_().m_188503_(500) == 0) {
                    this.setNotLanded();
                }
            } else {
                this.setNotLanded();
            }
        }
        if (this.isRainingAt(this.m_20183_())) {
            ++this.rainTicks;
            if (this.isLanded()) {
                this.setNotLanded();
            }
            if (this.targetPosition == null || this.isRainingAt(this.targetPosition)) {
                this.targetPosition = this.tryToFindPositionBlock(pos -> {
                    if (pos != null && !this.isRainingAt((BlockPos)pos) && this.f_19853_.m_46859_(pos)) {
                        for (Direction direction : Direction.values()) {
                            BlockPos offset;
                            if (direction == Direction.UP || !this.f_19853_.m_8055_(offset = pos.m_121945_(direction)).m_60659_((BlockGetter)this.f_19853_, offset, direction.m_122424_(), SupportType.CENTER)) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                });
            }
            if (this.m_217043_().m_188501_() < 0.0025f && this.rainTicks > 100) {
                this.m_6469_(DamageSource.f_19312_, 1.0f);
            }
        } else {
            this.rainTicks = 0;
            if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_123314_((Vec3i)this.m_20183_(), 1.0) && !this.isFlowers(this.targetPosition) && !this.isGrowable(this.targetPosition)) {
                if (this.f_19853_.m_46471_() && ((Biome)this.f_19853_.m_204166_(this.m_20183_()).m_203334_()).m_47530_() == Biome.Precipitation.RAIN) {
                    BlockPos temp;
                    boolean found = false;
                    for (Direction direction : Direction.values()) {
                        BlockPos offset;
                        if (direction == Direction.UP || !this.f_19853_.m_8055_(offset = blockpos.m_121945_(direction)).m_60659_((BlockGetter)this.f_19853_, offset, direction.m_122424_(), SupportType.CENTER) || !this.f_19853_.m_46859_(blockpos)) continue;
                        this.setLanded(direction);
                        this.targetPosition = null;
                        found = true;
                        break;
                    }
                    if (!found && !this.isRainingAt(temp = new BlockPos(this.m_20185_() + (double)this.f_19796_.m_188503_(5) - (double)this.f_19796_.m_188503_(5), this.m_20186_() + (double)this.f_19796_.m_188503_(4) - 1.0, this.m_20189_() + (double)this.f_19796_.m_188503_(5) - (double)this.f_19796_.m_188503_(5)))) {
                        this.targetPosition = temp;
                    }
                } else {
                    BlockPos destinationBlock = null;
                    boolean ranGrowable = false;
                    if (this.ticksUntilNextGrow <= 0) {
                        if (!this.hasNectar()) {
                            destinationBlock = this.tryToFindPositionBlock(this::isFlowers);
                        } else {
                            destinationBlock = this.tryToFindPositionBlock(this::isGrowable);
                            ranGrowable = true;
                        }
                    } else {
                        --this.ticksUntilNextGrow;
                    }
                    if (destinationBlock != null) {
                        this.targetPosition = destinationBlock;
                        this.setNotLanded();
                    } else {
                        boolean found = false;
                        if (this.f_19853_.m_45946_(playerPredicate, (LivingEntity)this) == null && (!this.hasNectar() || ranGrowable)) {
                            for (Direction direction : Direction.values()) {
                                BlockPos offset;
                                if (direction == Direction.UP || !this.f_19853_.m_8055_(offset = blockpos.m_121945_(direction)).m_60659_((BlockGetter)this.f_19853_, offset, direction.m_122424_(), SupportType.CENTER) || !this.f_19853_.m_46859_(blockpos)) continue;
                                this.setLanded(direction);
                                this.targetPosition = null;
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            for (int attempts = 0; !(attempts >= 5 || this.targetPosition != null && this.f_19853_.m_46859_(this.targetPosition)); ++attempts) {
                                this.targetPosition = new BlockPos(this.m_20185_() + (double)this.f_19796_.m_188503_(5) - (double)this.f_19796_.m_188503_(5), this.m_20186_() + (double)this.f_19796_.m_188503_(4) - 1.0, this.m_20189_() + (double)this.f_19796_.m_188503_(5) - (double)this.f_19796_.m_188503_(5));
                            }
                        }
                    }
                }
            }
            if (this.targetPosition != null && this.targetPosition.m_123314_((Vec3i)this.m_20183_(), 1.0)) {
                if (this.isFlowers(this.targetPosition) && !this.hasNectar()) {
                    this.setHasNectar(true);
                    this.targetPosition = null;
                } else if (this.isGrowable(this.targetPosition) && this.hasNectar()) {
                    BlockState blockstate = this.f_19853_.m_8055_(this.targetPosition);
                    Block block = blockstate.m_60734_();
                    IntegerProperty age = null;
                    if (block instanceof CropBlock) {
                        age = ((CropBlock)block).m_7959_();
                    } else if (block instanceof StemBlock) {
                        age = StemBlock.f_57013_;
                    } else if (block == Blocks.f_50685_) {
                        age = SweetBerryBushBlock.f_57244_;
                    }
                    if (age != null && age.m_6908_().contains((Integer)blockstate.m_61143_((Property)age) + 1)) {
                        this.f_19853_.m_46796_(2005, this.targetPosition, 0);
                        this.f_19853_.m_46597_(this.targetPosition, (BlockState)blockstate.m_61124_((Property)age, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)age) + 1)));
                        this.setHasNectar(false);
                        this.targetPosition = null;
                        this.ticksUntilNextGrow = this.m_217043_().m_188503_(3000) + 600;
                    }
                } else {
                    this.targetPosition = null;
                }
            }
        }
        if (!this.isLanded() && this.targetPosition != null) {
            if (this.m_5830_()) {
                this.targetPosition = this.tryToFindPositionSlow(pos -> {
                    AABB abb = this.m_20191_();
                    Vec3 diff = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5).m_82546_(this.m_20182_());
                    double length = diff.m_82553_();
                    diff = diff.m_82541_();
                    int i = 1;
                    while ((double)i < length) {
                        if (!this.f_19853_.m_45756_((Entity)this, abb = abb.m_82383_(diff))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                });
            }
            double d0 = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
            double d1 = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
            double d2 = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3d = this.m_20184_();
            Vec3 vec3d1 = vec3d.m_82520_((Math.signum(d0) * 0.5 - vec3d.f_82479_) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.f_82480_) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.f_82481_) * (double)0.1f);
            this.m_20256_(vec3d1);
            float f = (float)(Mth.m_14136_((double)vec3d1.f_82481_, (double)vec3d1.f_82479_) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
        }
    }

    private BlockPos tryToFindPositionBlock(Predicate<BlockPos> condition) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int i = 12;
        int j = 2;
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        pos.m_122190_((Vec3i)this.m_20183_()).m_122184_(i1, k - 1, j1);
                        if (condition.test(pos.m_7949_())) {
                            return pos.m_7949_();
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return null;
    }

    private BlockPos tryToFindPositionSlow(Predicate<BlockPos> condition) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int i = 12;
        int j = 2;
        boolean down = false;
        while (!down) {
            int k;
            int n = k = down ? -1 : 0;
            while (down ? k >= -j : k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n2 = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            pos.m_122190_((Vec3i)this.m_20183_()).m_122184_(i1, k, j1);
                            if (condition.test(pos.m_7949_())) {
                                return pos.m_7949_();
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k += down ? -1 : 1;
            }
            down = true;
        }
        return null;
    }

    private boolean isGrowable(BlockPos blockpos) {
        int k;
        int j;
        CropBlock cropsblock;
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof CropBlock ? !(cropsblock = (CropBlock)block).m_52307_(blockstate) : (block instanceof StemBlock ? (j = ((Integer)blockstate.m_61143_((Property)StemBlock.f_57013_)).intValue()) < 7 : block == Blocks.f_50685_ && (k = ((Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_)).intValue()) < 3)) {
            return blockstate.m_204336_(ModResources.Tags.Blocks.BUTTERFLY_GROWABLES);
        }
        return false;
    }

    private boolean isFlowers(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (state.m_204336_(BlockTags.f_13041_)) {
            if (state.m_60734_() == Blocks.f_50355_) {
                return state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.isLanded()) {
            this.setNotLanded();
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LANDED, (Object)compound.m_128451_("Landed"));
        this.f_19804_.m_135381_(HAS_NECTAR, (Object)compound.m_128471_("HasNectar"));
        this.ticksUntilNextGrow = compound.m_128451_("TimeUntilNextGrow");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Landed", ((Integer)this.f_19804_.m_135370_(LANDED)).intValue());
        compound.m_128379_("HasNectar", ((Boolean)this.f_19804_.m_135370_(HAS_NECTAR)).booleanValue());
        compound.m_128405_("TimeUntilNextGrow", this.ticksUntilNextGrow);
    }

    @Override
    protected float getRandomizedSize() {
        return ((float)this.f_19796_.m_188503_(30) + 1.0f) / 100.0f + 0.15f;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    @Override
    public EntityTypeContainer<? extends EntityButterfly> getContainer() {
        return ModEntities.BUTTERFLY;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return null;
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.BUTTERFLY;
    }

    @Override
    public void setContainerData(ItemStack bucket) {
        super.setContainerData(bucket);
        CompoundTag tag = bucket.m_41783_();
        tag.m_128350_("SizeTag", ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
        tag.m_128379_("HasNectar", ((Boolean)this.f_19804_.m_135370_(HAS_NECTAR)).booleanValue());
        bucket.m_41751_(tag);
    }

    @Override
    public void readFromContainerTag(CompoundTag tag) {
        super.readFromContainerTag(tag);
        if (tag.m_128441_("SizeTag")) {
            this.setSize(tag.m_128457_("SizeTag"));
            this.setHasNectar(tag.m_128471_("HasNectar"));
        }
    }

    public static void bottleTooltip(EntityTypeContainer<? extends Mob> container, ItemStack stack, Level worldIn, List<Component> tooltip) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (tag.m_128425_("SizeTag", 5)) {
                tooltip.add((Component)Component.m_237113_((String)("Size: " + tag.m_128457_("SizeTag"))).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("HasNectar") && tag.m_128471_("HasNectar")) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.betteranimalsplus.nectar").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    public static ResourceKey<Biome>[] getSpawnBiomes() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(BiomeTypes.getBiomes(BiomeTypes.FOREST));
        set.addAll(BiomeTypes.getBiomes(BiomeTypes.JUNGLE));
        set.addAll(BiomeTypes.getBiomes(BiomeTypes.MAGICAL));
        set.removeIf(b -> BiomeTypes.COLD.hasType((ResourceKey<Biome>)b) || !BiomeTypes.OVERWORLD.hasType((ResourceKey<Biome>)b));
        return set.toArray(new ResourceKey[0]);
    }
}

