/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LevelReader;

public abstract class MoveIntoBlockGoal
extends Goal {
    protected final PathfinderMob creature;
    public final double movementSpeed;
    protected int runDelay;
    protected int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.f_121853_;
    private boolean isAtDestination;
    private final int searchLength;
    private final int verticalSearchRange;
    protected int verticalSearchStart;

    public MoveIntoBlockGoal(PathfinderMob creature, double speedIn, int length) {
        this(creature, speedIn, length, 1);
    }

    public MoveIntoBlockGoal(PathfinderMob creatureIn, double speed, int length, int p_i48796_5_) {
        this.creature = creatureIn;
        this.movementSpeed = speed;
        this.searchLength = length;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = p_i48796_5_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = this.getRunDelay(this.creature);
        return this.searchForDestination();
    }

    protected int getRunDelay(PathfinderMob creatureIn) {
        return 200 + creatureIn.m_217043_().m_188503_(200);
    }

    public boolean m_8045_() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo((LevelReader)this.creature.f_19853_, this.destinationBlock);
    }

    public void m_8056_() {
        this.moveMobToBlock();
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.m_217043_().m_188503_(this.creature.m_217043_().m_188503_(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.creature.m_21573_().m_26519_((double)this.destinationBlock.m_123341_() + 0.5, (double)this.destinationBlock.m_123342_(), (double)this.destinationBlock.m_123343_() + 0.5, this.movementSpeed);
    }

    public double getTargetDistanceSq() {
        return 1.0;
    }

    public void m_8037_() {
        if (!this.destinationBlock.m_123314_((Vec3i)this.creature.m_20183_(), this.getTargetDistanceSq())) {
            this.isAtDestination = false;
            ++this.timeoutCounter;
            if (this.shouldMove()) {
                this.creature.m_21573_().m_26519_((double)this.destinationBlock.m_123341_() + 0.5, (double)this.destinationBlock.m_123342_(), (double)this.destinationBlock.m_123343_() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAtDestination = true;
            --this.timeoutCounter;
        }
    }

    public boolean shouldMove() {
        return this.timeoutCounter % 40 == 0;
    }

    protected boolean isAtDestination() {
        return this.isAtDestination;
    }

    protected boolean searchForDestination() {
        BlockPos blockpos = this.creature.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = this.verticalSearchStart;
        while (k <= this.verticalSearchRange) {
            for (int l = 0; l < this.searchLength; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        blockpos$mutableblockpos.m_122190_((Vec3i)blockpos).m_122184_(i1, k - 1, j1);
                        if (this.creature.m_21444_((BlockPos)blockpos$mutableblockpos) && this.shouldMoveTo((LevelReader)this.creature.f_19853_, (BlockPos)blockpos$mutableblockpos)) {
                            this.destinationBlock = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(LevelReader var1, BlockPos var2);
}

