/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Map;

public class SkullBlockCompatibilityHandler
implements NBTCompatibilityHandler {
    private static final Property<Direction> FacingProperty;

    @Override
    public <B extends BlockStateHolder<B>> boolean isAffectedBlock(B block) {
        return block.getBlockType() == BlockTypes.SKELETON_SKULL || block.getBlockType() == BlockTypes.SKELETON_WALL_SKULL;
    }

    @Override
    public <B extends BlockStateHolder<B>> BlockStateHolder<?> updateNBT(B block, Map<String, Tag> values) {
        BlockType type;
        String skullType;
        boolean isWall = block.getBlockType() == BlockTypes.SKELETON_WALL_SKULL;
        Tag typeTag = values.get("SkullType");
        if (typeTag instanceof ByteTag && (skullType = this.convertSkullType(((ByteTag)typeTag).getValue(), isWall)) != null && (type = BlockTypes.get("minecraft:" + skullType)) != null) {
            BlockStateHolder<BlockState> state = type.getDefaultState();
            if (isWall) {
                Property newProp = type.getProperty("facing");
                state = ((BlockState)state).with(newProp, (Object)block.getState(FacingProperty));
            } else {
                Tag rotTag = values.get("Rot");
                if (rotTag instanceof ByteTag) {
                    Property newProp = type.getProperty("rotation");
                    state = ((BlockState)state).with(newProp, ((ByteTag)rotTag).getValue());
                }
            }
            values.remove("SkullType");
            values.remove("Rot");
            return state;
        }
        return block;
    }

    private String convertSkullType(Byte oldType, boolean isWall) {
        switch (oldType) {
            case 0: {
                return isWall ? "skeleton_wall_skull" : "skeleton_skull";
            }
            case 1: {
                return isWall ? "wither_skeleton_wall_skull" : "wither_skeleton_skull";
            }
            case 2: {
                return isWall ? "zombie_wall_head" : "zombie_head";
            }
            case 3: {
                return isWall ? "player_wall_head" : "player_head";
            }
            case 4: {
                return isWall ? "creeper_wall_head" : "creeper_head";
            }
            case 5: {
                return isWall ? "dragon_wall_head" : "dragon_head";
            }
        }
        return null;
    }

    static {
        Property tempFacing;
        try {
            tempFacing = BlockTypes.SKELETON_WALL_SKULL.getProperty("facing");
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            tempFacing = null;
        }
        FacingProperty = tempFacing;
    }
}

