/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public enum Direction {
    NORTH(Vector3.at(0.0, 0.0, -1.0), Flag.CARDINAL),
    EAST(Vector3.at(1.0, 0.0, 0.0), Flag.CARDINAL),
    SOUTH(Vector3.at(0.0, 0.0, 1.0), Flag.CARDINAL),
    WEST(Vector3.at(-1.0, 0.0, 0.0), Flag.CARDINAL),
    UP(Vector3.at(0.0, 1.0, 0.0), Flag.UPRIGHT),
    DOWN(Vector3.at(0.0, -1.0, 0.0), Flag.UPRIGHT),
    NORTHEAST(Vector3.at(1.0, 0.0, -1.0), Flag.ORDINAL),
    NORTHWEST(Vector3.at(-1.0, 0.0, -1.0), Flag.ORDINAL),
    SOUTHEAST(Vector3.at(1.0, 0.0, 1.0), Flag.ORDINAL),
    SOUTHWEST(Vector3.at(-1.0, 0.0, 1.0), Flag.ORDINAL),
    WEST_NORTHWEST(Vector3.at(-Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    WEST_SOUTHWEST(Vector3.at(-Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    NORTH_NORTHWEST(Vector3.at(-Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    NORTH_NORTHEAST(Vector3.at(Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    EAST_NORTHEAST(Vector3.at(Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    EAST_SOUTHEAST(Vector3.at(Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    SOUTH_SOUTHEAST(Vector3.at(Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL),
    SOUTH_SOUTHWEST(Vector3.at(-Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL);

    private final Vector3 direction;
    private final int flags;
    private final BlockVector3 blockPoint;

    private Direction(Vector3 vector, int flags) {
        this.blockPoint = vector.toBlockPoint();
        this.direction = vector.normalize();
        this.flags = flags;
    }

    public boolean isCardinal() {
        return (this.flags & Flag.CARDINAL) > 0;
    }

    public boolean isOrdinal() {
        return (this.flags & Flag.ORDINAL) > 0;
    }

    public boolean isSecondaryOrdinal() {
        return (this.flags & Flag.SECONDARY_ORDINAL) > 0;
    }

    public boolean isUpright() {
        return (this.flags & Flag.UPRIGHT) > 0;
    }

    public Vector3 toVector() {
        return this.direction;
    }

    public BlockVector3 toBlockVector() {
        return this.blockPoint;
    }

    @Nullable
    public static Direction findClosest(Vector3 vector, int flags) {
        if ((flags & Flag.UPRIGHT) == 0) {
            vector = vector.withY(0.0);
        }
        vector = vector.normalize();
        Direction closest = null;
        double closestDot = -2.0;
        for (Direction direction : Direction.values()) {
            double dot;
            if ((~flags & direction.flags) > 0 || !((dot = direction.toVector().dot(vector)) >= closestDot)) continue;
            closest = direction;
            closestDot = dot;
        }
        return closest;
    }

    public static List<Direction> valuesOf(int flags) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if ((~flags & direction.flags) != 0) continue;
            directions.add(direction);
        }
        return directions;
    }

    public static Optional<Direction> fromRotationIndex(int rotation) {
        switch (rotation) {
            case 0: {
                return Optional.of(SOUTH);
            }
            case 1: {
                return Optional.of(SOUTH_SOUTHWEST);
            }
            case 2: {
                return Optional.of(SOUTHWEST);
            }
            case 3: {
                return Optional.of(WEST_SOUTHWEST);
            }
            case 4: {
                return Optional.of(WEST);
            }
            case 5: {
                return Optional.of(WEST_NORTHWEST);
            }
            case 6: {
                return Optional.of(NORTHWEST);
            }
            case 7: {
                return Optional.of(NORTH_NORTHWEST);
            }
            case 8: {
                return Optional.of(NORTH);
            }
            case 9: {
                return Optional.of(NORTH_NORTHEAST);
            }
            case 10: {
                return Optional.of(NORTHEAST);
            }
            case 11: {
                return Optional.of(EAST_NORTHEAST);
            }
            case 12: {
                return Optional.of(EAST);
            }
            case 13: {
                return Optional.of(EAST_SOUTHEAST);
            }
            case 14: {
                return Optional.of(SOUTHEAST);
            }
            case 15: {
                return Optional.of(SOUTH_SOUTHEAST);
            }
        }
        return Optional.empty();
    }

    public OptionalInt toRotationIndex() {
        switch (this) {
            case SOUTH: {
                return OptionalInt.of(0);
            }
            case SOUTH_SOUTHWEST: {
                return OptionalInt.of(1);
            }
            case SOUTHWEST: {
                return OptionalInt.of(2);
            }
            case WEST_SOUTHWEST: {
                return OptionalInt.of(3);
            }
            case WEST: {
                return OptionalInt.of(4);
            }
            case WEST_NORTHWEST: {
                return OptionalInt.of(5);
            }
            case NORTHWEST: {
                return OptionalInt.of(6);
            }
            case NORTH_NORTHWEST: {
                return OptionalInt.of(7);
            }
            case NORTH: {
                return OptionalInt.of(8);
            }
            case NORTH_NORTHEAST: {
                return OptionalInt.of(9);
            }
            case NORTHEAST: {
                return OptionalInt.of(10);
            }
            case EAST_NORTHEAST: {
                return OptionalInt.of(11);
            }
            case EAST: {
                return OptionalInt.of(12);
            }
            case EAST_SOUTHEAST: {
                return OptionalInt.of(13);
            }
            case SOUTHEAST: {
                return OptionalInt.of(14);
            }
            case SOUTH_SOUTHEAST: {
                return OptionalInt.of(15);
            }
        }
        return OptionalInt.empty();
    }

    public static final class Flag {
        public static int CARDINAL = 1;
        public static int ORDINAL = 2;
        public static int SECONDARY_ORDINAL = 4;
        public static int UPRIGHT = 8;
        public static int ALL = CARDINAL | ORDINAL | SECONDARY_ORDINAL | UPRIGHT;

        private Flag() {
        }
    }
}

