/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.event.PlayerChangedTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.net.SendMessageResponseMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public abstract class Team
extends TeamBase {
    public final TeamManager manager;
    boolean shouldSave;

    public Team(TeamManager m) {
        this.id = Util.f_137441_;
        this.manager = m;
        this.properties.collect();
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    @Override
    public void save() {
        this.shouldSave = true;
        this.manager.nameMap = null;
    }

    public List<ServerPlayer> getOnlineRanked(TeamRank rank) {
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        for (UUID id : this.getRanked(rank).keySet()) {
            ServerPlayer player = FTBTUtils.getPlayerByUUID(this.manager.server, id);
            if (player == null) continue;
            list.add(player);
        }
        return list;
    }

    public List<ServerPlayer> getOnlineMembers() {
        return this.getOnlineRanked(TeamRank.MEMBER);
    }

    void onCreated(@Nullable ServerPlayer p) {
        if (p != null) {
            ((Consumer)TeamEvent.CREATED.invoker()).accept(new TeamCreatedEvent(this, p));
        }
        this.save();
        this.manager.save();
    }

    void updateCommands(ServerPlayer player) {
        this.manager.server.m_6846_().m_11289_(player);
    }

    void changedTeam(@Nullable Team prev, UUID player, @Nullable ServerPlayer p, boolean deleted) {
        ((Consumer)TeamEvent.PLAYER_CHANGED.invoker()).accept(new PlayerChangedTeamEvent(this, prev, player, p));
        if (prev instanceof PartyTeam) {
            ((Consumer)TeamEvent.PLAYER_LEFT_PARTY.invoker()).accept(new PlayerLeftPartyTeamEvent(prev, (PlayerTeam)this, player, p, deleted));
        } else if (prev instanceof PlayerTeam && p != null) {
            ((Consumer)TeamEvent.PLAYER_JOINED_PARTY.invoker()).accept(new PlayerJoinedPartyTeamEvent(this, (PlayerTeam)prev, p));
        }
        if (deleted && prev != null) {
            ((Consumer)TeamEvent.DELETED.invoker()).accept(new TeamEvent(prev));
        }
        if (p != null) {
            this.updateCommands(p);
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.m_128359_("id", this.getId().toString());
        tag.m_128359_("type", this.getType().m_7912_());
        this.serializeExtraNBT((CompoundTag)tag);
        SNBTCompoundTag ranksNBT = new SNBTCompoundTag();
        for (Map.Entry entry : this.ranks.entrySet()) {
            ranksNBT.m_128359_(((UUID)entry.getKey()).toString(), ((TeamRank)((Object)entry.getValue())).m_7912_());
        }
        tag.m_128365_("ranks", (Tag)ranksNBT);
        tag.m_128365_("properties", (Tag)this.properties.write((CompoundTag)new SNBTCompoundTag()));
        ListTag messageHistoryTag = new ListTag();
        for (TeamMessage m : this.getMessageHistory()) {
            SNBTCompoundTag mt = new SNBTCompoundTag();
            mt.singleLine();
            mt.m_128359_("from", m.sender.toString());
            mt.m_128356_("date", m.date);
            mt.m_128359_("text", Component.Serializer.m_130703_((Component)m.text));
            messageHistoryTag.add((Object)mt);
        }
        tag.m_128365_("message_history", (Tag)messageHistoryTag);
        ((Consumer)TeamEvent.SAVED.invoker()).accept(new TeamEvent(this));
        tag.m_128365_("extra", (Tag)this.extraData);
        return tag;
    }

    protected void serializeExtraNBT(CompoundTag tag) {
    }

    public void deserializeNBT(CompoundTag tag) {
        this.ranks.clear();
        CompoundTag ranksNBT = tag.m_128469_("ranks");
        for (String s : ranksNBT.m_128431_()) {
            this.ranks.put(UUID.fromString(s), (TeamRank)((Object)TeamRank.NAME_MAP.get(ranksNBT.m_128461_(s))));
        }
        this.properties.read(tag.m_128469_("properties"));
        this.extraData = tag.m_128469_("extra");
        this.messageHistory.clear();
        ListTag messageHistoryTag = tag.m_128437_("message_history", 10);
        for (int i = 0; i < messageHistoryTag.size(); ++i) {
            CompoundTag mt = messageHistoryTag.m_128728_(i);
            this.addMessage(new TeamMessage(UUID.fromString(mt.m_128461_("from")), mt.m_128454_("date"), (Component)Component.Serializer.m_130701_((String)mt.m_128461_("text"))));
        }
        ((Consumer)TeamEvent.LOADED.invoker()).accept(new TeamEvent(this));
    }

    public <T> int settings(CommandSourceStack source, TeamProperty<T> key, String value) throws CommandSyntaxException {
        if (value.isEmpty()) {
            MutableComponent keyc = Component.m_237115_((String)("ftbteamsconfig." + key.id.m_135827_() + "." + key.id.m_135815_()));
            keyc.m_130940_(ChatFormatting.YELLOW);
            MutableComponent valuec = Component.m_237113_((String)key.toString(this.getProperty(key)));
            valuec.m_130940_(ChatFormatting.AQUA);
            source.m_81354_((Component)Component.m_237113_((String)"").m_7220_((Component)keyc).m_130946_(" is set to ").m_7220_((Component)valuec), true);
        } else {
            Optional<T> optional = key.fromString(value);
            if (optional.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to parse value!"));
                return 0;
            }
            TeamProperties old = this.properties.copy();
            this.setProperty(key, optional.get());
            MutableComponent keyc = Component.m_237115_((String)("ftbteamsconfig." + key.id.m_135827_() + "." + key.id.m_135815_()));
            keyc.m_130940_(ChatFormatting.YELLOW);
            MutableComponent valuec = Component.m_237113_((String)value);
            valuec.m_130940_(ChatFormatting.AQUA);
            source.m_81354_((Component)Component.m_237113_((String)"Set ").m_7220_((Component)keyc).m_130946_(" to ").m_7220_((Component)valuec), true);
            ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(this, old));
        }
        return 1;
    }

    public int denyInvite(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        if (this.isInvited(player.m_20148_()) && !this.isMember(player.m_20148_())) {
            this.ranks.put(player.m_20148_(), TeamRank.ALLY);
            source.m_81354_((Component)Component.m_237115_((String)"ftbteams.message.declined"), true);
            this.save();
            this.manager.syncTeamsToAll(this);
        }
        return 1;
    }

    public int info(CommandSourceStack source) throws CommandSyntaxException {
        source.m_81354_((Component)Component.m_237119_(), false);
        MutableComponent infoComponent = Component.m_237113_((String)"");
        infoComponent.m_7383_().m_131136_(Boolean.valueOf(true));
        infoComponent.m_130946_("== ");
        infoComponent.m_7220_(this.getName());
        infoComponent.m_130946_(" ==");
        source.m_81354_((Component)infoComponent, false);
        source.m_81354_((Component)Component.m_237110_((String)"ftbteams.info.id", (Object[])new Object[]{Component.m_237113_((String)this.getId().toString()).m_130940_(ChatFormatting.YELLOW)}), false);
        source.m_81354_((Component)Component.m_237110_((String)"ftbteams.info.short_id", (Object[])new Object[]{Component.m_237113_((String)this.getStringID()).m_130940_(ChatFormatting.YELLOW)}).m_130946_(" [" + this.getType().m_7912_() + "]"), false);
        if (this.getOwner().equals(Util.f_137441_)) {
            source.m_81354_((Component)Component.m_237110_((String)"ftbteams.info.owner", (Object[])new Object[]{Component.m_237115_((String)"ftbteams.info.owner.none")}), false);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)"ftbteams.info.owner", (Object[])new Object[]{this.manager.getName(this.getOwner())}), false);
        }
        source.m_81354_((Component)Component.m_237115_((String)"ftbteams.info.members"), false);
        if (this.getMembers().isEmpty()) {
            source.m_81354_((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)"ftbteams.info.members.none")), false);
        } else {
            for (UUID member : this.getMembers()) {
                source.m_81354_((Component)Component.m_237113_((String)"- ").m_7220_(this.manager.getName(member)), false);
            }
        }
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(this, source));
        return 1;
    }

    public UUID getOwner() {
        return Util.f_137441_;
    }

    public int msg(ServerPlayer player, String message) throws CommandSyntaxException {
        this.sendMessage(player.m_20148_(), TextComponentUtils.withLinks((String)message));
        return 1;
    }

    public void sendMessage(UUID from, Component text) {
        this.addMessage(new TeamMessage(from, System.currentTimeMillis(), text));
        MutableComponent component = Component.m_237113_((String)"<");
        component.m_7220_(this.manager.getName(from));
        component.m_130946_(" @");
        component.m_7220_(this.getName());
        component.m_130946_("> ");
        component.m_7220_(text);
        for (ServerPlayer p : this.getOnlineMembers()) {
            p.m_5661_((Component)component, false);
            new SendMessageResponseMessage(from, text).sendTo(p);
        }
        this.save();
    }
}

