/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum BlockStatesProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Collection properties = state.m_61147_();
        if (properties.isEmpty()) {
            return;
        }
        IElementHelper helper = tooltip.getElementHelper();
        ITooltip box = helper.tooltip();
        properties.forEach(p -> {
            Comparable value = state.m_61143_(p);
            MutableComponent valueText = Component.m_237113_((String)(" " + value)).m_130944_(new ChatFormatting[0]);
            if (p instanceof BooleanProperty) {
                valueText = valueText.m_130940_(value == Boolean.TRUE ? ChatFormatting.GREEN : ChatFormatting.RED);
            }
            box.add((Component)Component.m_237113_((String)(p.m_61708_() + ":")).m_7220_((Component)valueText));
        });
        tooltip.add(helper.box(box));
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_BLOCK_STATES;
    }

    @Override
    public int getDefaultPriority() {
        return -4500;
    }

    @Override
    public boolean enabledByDefault() {
        return false;
    }
}

