/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.interfaces.ICanSkipGUI;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.gui.CokerUnitContainer;
import flaxbeard.immersivepetroleum.common.gui.IPMenuProvider;
import flaxbeard.immersivepetroleum.common.multiblocks.CokerUnitMultiblock;
import flaxbeard.immersivepetroleum.common.util.AABBUtils;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CokerUnitTileEntity
extends PoweredMultiblockBlockEntity<CokerUnitTileEntity, CokerUnitRecipe>
implements IPCommonTickableTile,
ICanSkipGUI,
IPMenuProvider<CokerUnitTileEntity>,
IEBlockInterfaces.IBlockBounds {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int CHAMBER_A = 0;
    public static final int CHAMBER_B = 1;
    public static final BlockPos Chamber_A_OUT = new BlockPos(2, 0, 2);
    public static final BlockPos Chamber_B_OUT = new BlockPos(6, 0, 2);
    public static final BlockPos Fluid_IN = new BlockPos(2, 0, 4);
    public static final BlockPos Fluid_OUT = new BlockPos(5, 0, 4);
    public static final BlockPos Item_IN = new BlockPos(3, 0, 4);
    public static final Set<PoweredMultiblockBlockEntity.MultiblockFace> Energy_IN = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(6, 1, 4, RelativeBlockFace.FRONT), (Object)new PoweredMultiblockBlockEntity.MultiblockFace(7, 1, 4, RelativeBlockFace.FRONT));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(1, 1, 4));
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)Inventory.values().length, (Object)ItemStack.f_41583_);
    public final FluidTank[] bufferTanks = new FluidTank[]{new FluidTank(16000), new FluidTank(16000)};
    public final CokingChamber[] chambers = new CokingChamber[]{new CokingChamber(64, 8000), new CokingChamber(64, 8000)};
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make((Object)this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, (ResettableCapability)new ResettableCapability((Object)new IEInventoryHandler(1, (IIEInventory)this, 0, new boolean[]{true}, new boolean[8])));
    private final MultiblockCapability<IFluidHandler> fluidOutHandler = MultiblockCapability.make((Object)this, be -> be.fluidOutHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidOutput(new IFluidTank[]{this.bufferTanks[1]}));
    private final MultiblockCapability<IFluidHandler> fluidInHandler = MultiblockCapability.make((Object)this, be -> be.fluidInHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.bufferTanks[0]}));
    int updateDelay = 0;
    int lastCompared = 0;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(CokerUnitTileEntity::getShape);

    public CokerUnitTileEntity(BlockEntityType<CokerUnitTileEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super((IETemplateMultiblock)CokerUnitMultiblock.INSTANCE, 24000, true, type, pWorldPosition, pBlockState);
        this.bufferTanks[0].setValidator(fs -> CokerUnitRecipe.hasRecipeWithInput(fs, true));
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.bufferTanks[0].readFromNBT(nbt.m_128469_("tank0"));
        this.bufferTanks[1].readFromNBT(nbt.m_128469_("tank1"));
        this.chambers[0].readFromNBT(nbt.m_128469_("chamber0"));
        this.chambers[1].readFromNBT(nbt.m_128469_("chamber1"));
        if (!descPacket) {
            this.readInventory(nbt.m_128469_("inventory"));
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128365_("tank0", (Tag)this.bufferTanks[0].writeToNBT(new CompoundTag()));
        nbt.m_128365_("tank1", (Tag)this.bufferTanks[1].writeToNBT(new CompoundTag()));
        nbt.m_128365_("chamber0", (Tag)this.chambers[0].writeToNBT(new CompoundTag()));
        nbt.m_128365_("chamber1", (Tag)this.chambers[1].writeToNBT(new CompoundTag()));
        if (!descPacket) {
            nbt.m_128365_("inventory", (Tag)this.writeInventory(this.inventory));
        }
    }

    protected void readInventory(CompoundTag nbt) {
        NonNullList list = NonNullList.m_122779_();
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)list);
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = ItemStack.f_41583_;
            if (i < list.size()) {
                stack = (ItemStack)list.get(i);
            }
            this.inventory.set(i, (Object)stack);
        }
    }

    protected CompoundTag writeInventory(NonNullList<ItemStack> list) {
        return ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), list);
    }

    public void doGraphicalUpdates() {
        this.updateMasterBlock(null, true);
    }

    public CokerUnitRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public boolean additionalCanProcessCheck(MultiblockProcess<CokerUnitRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if ((facing == null || this.posInMultiblock.equals((Object)Item_IN)) && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.insertionHandler.getAndCast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (facing == null || facing == this.getFacing().m_122424_())) {
                return this.fluidOutHandler.getAndCast();
            }
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (facing == null || facing == this.getFacing().m_122424_())) {
                return this.fluidInHandler.getAndCast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(MultiblockProcess<CokerUnitRecipe> process) {
    }

    @Override
    public void tickClient() {
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        boolean debug = false;
        for (int i = 0; i < this.chambers.length; ++i) {
            if (!debug && this.chambers[i].getState() != CokingState.DUMPING) continue;
            BlockPos cOutPos = this.getBlockPosForPos(i == 0 ? Chamber_A_OUT : Chamber_B_OUT);
            Vec3 origin = new Vec3((double)cOutPos.m_123341_() + 0.5, (double)cOutPos.m_123342_() + 2.125, (double)cOutPos.m_123343_() + 0.5);
            for (int j = 0; j < 10; ++j) {
                double rX = (Math.random() - 0.5) * 0.4;
                double rY = (Math.random() - 0.5) * 0.5;
                double rdx = (Math.random() - 0.5) * 0.1;
                double rdy = (Math.random() - 0.5) * 0.1;
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, origin.f_82479_ + rX, origin.f_82480_, origin.f_82481_ + rY, rdx, -(Math.random() * 0.06 + 0.11), rdy);
            }
        }
    }

    @Override
    public void tickServer() {
        ItemStack container;
        if (this.isDummy()) {
            return;
        }
        super.tickServer();
        boolean update = false;
        if (!this.isRSDisabled()) {
            CokerUnitRecipe recipe;
            ItemStack inputStack = this.getInventory(Inventory.INPUT);
            FluidStack inputFluid = this.bufferTanks[0].getFluid();
            if (!inputStack.m_41619_() && inputFluid.getAmount() > 0 && CokerUnitRecipe.hasRecipeWithInput(inputStack, inputFluid) && (recipe = CokerUnitRecipe.findRecipe(inputStack, inputFluid)) != null && inputStack.m_41613_() >= recipe.inputItem.getCount() && inputFluid.getAmount() >= recipe.inputFluid.getAmount()) {
                for (CokingChamber chamber : this.chambers) {
                    boolean skipNext = false;
                    switch (chamber.getState()) {
                        case STANDBY: {
                            if (!chamber.setRecipe(recipe)) break;
                            update = true;
                            skipNext = true;
                            break;
                        }
                        case PROCESSING: {
                            int acceptedStack = chamber.addStack(this.copyStack(inputStack, recipe.inputItem.getCount()), true);
                            if (acceptedStack < recipe.inputItem.getCount()) break;
                            acceptedStack = Math.min(acceptedStack, inputStack.m_41613_());
                            chamber.addStack(this.copyStack(inputStack, acceptedStack), false);
                            inputStack.m_41774_(acceptedStack);
                            skipNext = true;
                            update = true;
                            break;
                        }
                    }
                    if (skipNext) break;
                }
            }
            for (int i = 0; i < this.chambers.length; ++i) {
                update |= this.chambers[i].tick(this, i);
            }
        }
        if (!this.getInventory(Inventory.INPUT_FILLED).m_41619_() && this.bufferTanks[0].getFluidAmount() < this.bufferTanks[0].getCapacity() && !(container = Utils.drainFluidContainer((IFluidHandler)this.bufferTanks[0], (ItemStack)this.getInventory(Inventory.INPUT_FILLED), (ItemStack)this.getInventory(Inventory.INPUT_EMPTY))).m_41619_()) {
            if (!this.getInventory(Inventory.INPUT_EMPTY).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)this.getInventory(Inventory.INPUT_EMPTY), (ItemStack)container)) {
                this.getInventory(Inventory.INPUT_EMPTY).m_41769_(container.m_41613_());
            } else if (this.getInventory(Inventory.INPUT_EMPTY).m_41619_()) {
                this.setInventory(Inventory.INPUT_EMPTY, container.m_41777_());
            }
            this.getInventory(Inventory.INPUT_FILLED).m_41774_(1);
            if (this.getInventory(Inventory.INPUT_FILLED).m_41613_() <= 0) {
                this.setInventory(Inventory.INPUT_FILLED, ItemStack.f_41583_);
            }
            update = true;
        }
        if (this.bufferTanks[1].getFluidAmount() > 0) {
            ItemStack filledContainer;
            if (!this.getInventory(Inventory.OUTPUT_EMPTY).m_41619_() && !(filledContainer = FluidHelper.fillFluidContainer((IFluidHandler)this.bufferTanks[1], this.getInventory(Inventory.OUTPUT_EMPTY), this.getInventory(Inventory.OUTPUT_FILLED), null)).m_41619_()) {
                if (this.getInventory(Inventory.OUTPUT_FILLED).m_41613_() == 1 && !FluidHelper.isFluidContainerFull(filledContainer)) {
                    this.setInventory(Inventory.OUTPUT_FILLED, filledContainer.m_41777_());
                } else {
                    if (!this.getInventory(Inventory.OUTPUT_FILLED).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)this.getInventory(Inventory.OUTPUT_FILLED), (ItemStack)filledContainer)) {
                        this.getInventory(Inventory.OUTPUT_FILLED).m_41769_(filledContainer.m_41613_());
                    } else if (this.getInventory(Inventory.OUTPUT_FILLED).m_41619_()) {
                        this.setInventory(Inventory.OUTPUT_FILLED, filledContainer.m_41777_());
                    }
                    this.getInventory(Inventory.OUTPUT_EMPTY).m_41774_(1);
                    if (this.getInventory(Inventory.OUTPUT_EMPTY).m_41613_() <= 0) {
                        this.setInventory(Inventory.OUTPUT_EMPTY, ItemStack.f_41583_);
                    }
                }
                update = true;
            }
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).m_121945_(this.getFacing().m_122424_());
            update |= FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)outPos, (Direction)this.getFacing()).map(out -> {
                if (this.bufferTanks[1].getFluidAmount() > 0) {
                    FluidStack fs = this.bufferTanks[1].getFluid();
                    int accepted = out.fill(fs = FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), 250)), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted > 0) {
                        boolean iePipe = this.f_58857_.m_7702_(outPos) instanceof IFluidPipe;
                        int drained = out.fill(FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                        this.bufferTanks[1].drain(FluidHelper.copyFluid(fs, drained), IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                }
                return false;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
        this.updateComparatorOutput();
    }

    private void updateComparatorOutput() {
        boolean update = false;
        ItemStack stack = this.getInventory(Inventory.INPUT);
        if (!stack.m_41619_()) {
            int compared = Mth.m_14045_((int)Mth.m_14143_((float)((float)stack.m_41613_() / (float)Math.min(this.getSlotLimit(Inventory.INPUT.id()), stack.m_41741_()) * 15.0f)), (int)0, (int)15);
            if (compared != this.lastCompared) {
                this.lastCompared = compared;
                update = true;
            }
        } else if (this.lastCompared != 0) {
            this.lastCompared = 0;
            update = true;
        }
        if (update) {
            this.getRedstonePos().forEach(pos -> {
                BlockPos p = this.getBlockPosForPos((BlockPos)pos);
                this.f_58857_.m_46672_(p, this.f_58857_.m_8055_(p).m_60734_());
            });
        }
    }

    public int getComparatorInputOverride() {
        CokerUnitTileEntity master;
        if (this.isRedstonePos() && (master = (CokerUnitTileEntity)this.master()) != null) {
            return master.lastCompared;
        }
        return 0;
    }

    private ItemStack copyStack(ItemStack stack, int amount) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(amount);
        return copy;
    }

    public ItemStack getInventory(Inventory inv) {
        return (ItemStack)this.inventory.get(inv.id());
    }

    public ItemStack setInventory(Inventory inv, ItemStack stack) {
        return (ItemStack)this.inventory.set(inv.id(), (Object)stack);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected CokerUnitRecipe getRecipeForId(Level level, ResourceLocation id) {
        return CokerUnitRecipe.recipes.get(id);
    }

    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return this.bufferTanks;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 2;
    }

    public float getMinProcessDistance(MultiblockProcess<CokerUnitRecipe> process) {
        return 1.0f;
    }

    public int getComparatedSize() {
        return 1;
    }

    @Override
    public CokerUnitTileEntity getGuiMaster() {
        return (CokerUnitTileEntity)this.master();
    }

    @Override
    public boolean canUseGui(@Nonnull Player player) {
        return this.formed;
    }

    @Override
    public boolean skipGui(Direction hitFace) {
        Direction facing = this.getFacing();
        if (this.getEnergyPos().stream().anyMatch(t -> t.posInMultiblock().equals((Object)this.posInMultiblock)) && hitFace == facing) {
            return true;
        }
        if (this.getRedstonePos().contains(this.posInMultiblock) && hitFace == facing.m_122424_()) {
            return true;
        }
        if (this.posInMultiblock.equals((Object)Fluid_IN) || this.posInMultiblock.equals((Object)Fluid_OUT)) {
            return true;
        }
        return this.posInMultiblock.equals((Object)Item_IN);
    }

    @Override
    @Nonnull
    public IPMenuProvider.BEContainerIP<CokerUnitTileEntity, CokerUnitContainer> getContainerType() {
        return IPMenuTypes.COKER;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public boolean isLadder() {
        int bX = this.posInMultiblock.m_123341_();
        int bY = this.posInMultiblock.m_123342_();
        int bZ = this.posInMultiblock.m_123343_();
        if (bX == 8 && bZ == 2 && bY >= 5 && bY <= 13) {
            return true;
        }
        return bX == 7 && bZ == 2 && bY >= 15 && bY <= 21;
    }

    @Nonnull
    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        boolean upper;
        int x = posInMultiblock.m_123341_();
        int y = posInMultiblock.m_123342_();
        int z = posInMultiblock.m_123343_();
        ArrayList<AABB> main = new ArrayList<AABB>();
        if (y >= 15 && y <= 22 && z == 2 && (x == 2 || x == 6)) {
            AABBUtils.box16(main, 4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
        }
        if (y == 22 || y == 18) {
            if (x == 1) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
            }
            if (x == 7) {
                AABBUtils.box16(main, 15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
            }
            if (z == 1) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
            }
            if (z == 3) {
                AABBUtils.box16(main, 0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
            }
        }
        if ((y == 14 || y == 9) && x >= 0 && x <= 8) {
            if (z == 0) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
            }
            if (z == 4) {
                AABBUtils.box16(main, 0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
            }
            if (x == 8 && (z == 0 || z == 4)) {
                AABBUtils.box16(main, 15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
            }
            if (x == 0 && (z == 0 || z == 4)) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
            }
        }
        if (!(y != 8 && y != 13 || x >= 1 && x <= 3 && z >= 1 && z <= 3 || x >= 5 && x <= 7 && z >= 1 && z <= 3 || x == 8 && z == 2)) {
            AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
        }
        if ((y == 17 || y == 21) && x >= 1 && x <= 7 && z >= 1 && z <= 3 && (x != 2 && x != 6 && x != 7 || z != 2)) {
            AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
        }
        boolean lower = y >= 4 && y <= 13;
        boolean bl = upper = y >= 14 && y <= 21;
        if (lower || upper) {
            if (lower && x == 0 && z == 0 || upper && (x == 1 && z == 1 || x == 5 && z == 1)) {
                AABBUtils.box16(main, 2.0, 0.0, 2.0, 6.0, 16.0, 6.0);
            }
            if (lower && x == 0 && z == 4 || upper && (x == 1 && z == 3 || x == 5 && z == 3)) {
                AABBUtils.box16(main, 2.0, 0.0, 10.0, 6.0, 16.0, 14.0);
            }
            if (lower && x == 8 && z == 0 || upper && (x == 3 && z == 1 || x == 7 && z == 1)) {
                AABBUtils.box16(main, 10.0, 0.0, 2.0, 14.0, 16.0, 6.0);
            }
            if (lower && x == 8 && z == 4 || upper && (x == 3 && z == 3 || x == 7 && z == 3)) {
                AABBUtils.box16(main, 10.0, 0.0, 10.0, 14.0, 16.0, 14.0);
            }
            if (lower && x == 4 && z == 0) {
                AABBUtils.box16(main, 6.0, 0.0, 2.0, 10.0, 16.0, 6.0);
            }
            if (lower && x == 4 && z == 4) {
                AABBUtils.box16(main, 6.0, 0.0, 10.0, 10.0, 16.0, 14.0);
            }
        }
        if (y == 6 || y == 11) {
            if (x >= 0 && x <= 8) {
                double xb;
                double xa;
                if (z == 0) {
                    xa = x == 0 ? 2.0 : 0.0;
                    xb = x == 8 ? 14.0 : 16.0;
                    AABBUtils.box16(main, xa, 2.0, 2.0, xb, 6.0, 6.0);
                }
                if (z == 4) {
                    xa = x == 0 ? 2.0 : 0.0;
                    xb = x == 8 ? 14.0 : 16.0;
                    AABBUtils.box16(main, xa, 2.0, 10.0, xb, 6.0, 14.0);
                }
            }
            if (z >= 0 && z <= 4) {
                double zb;
                double za;
                if (x == 0) {
                    za = z == 0 ? 2.0 : 0.0;
                    zb = z == 4 ? 14.0 : 16.0;
                    AABBUtils.box16(main, 2.0, 2.0, za, 6.0, 6.0, zb);
                }
                if (x == 8 && z != 2) {
                    za = z == 0 ? 2.0 : 0.0;
                    zb = z == 4 ? 14.0 : 16.0;
                    AABBUtils.box16(main, 10.0, 2.0, za, 14.0, 6.0, zb);
                }
            }
        }
        boolean u = false;
        boolean d = false;
        boolean n = false;
        boolean s = false;
        boolean e = false;
        boolean w = false;
        boolean v = false;
        boolean hX = false;
        boolean hZ = false;
        if (y >= 1 && y <= 7 && y != 3 && x == 2 && z == 4 || y >= 9 && y <= 13 && x == 0 && z == 2 || y == 1 && x == 5 && z == 4) {
            v = true;
            if (y == 2 || y == 7 || x == 5 && z == 4) {
                u = true;
            }
            if (y == 1 || y == 4 || y == 9) {
                d = true;
            }
        }
        if (y == 0 && x == 3 && z == 3) {
            s = true;
            n = true;
            hZ = true;
        }
        if (y == 1 && x == 4 && z == 2) {
            d = true;
            u = true;
            v = true;
        }
        if (y == 2) {
            if (x == 3 && z == 3) {
                w = true;
                hX = true;
            }
            if (x == 4 && z == 3) {
                e = true;
                hX = true;
            }
            if ((x == 3 || x == 5) && z == 2) {
                w = true;
                e = true;
                hX = true;
            }
            if (x == 4 && z == 2) {
                d = true;
                w = true;
                e = true;
                hX = true;
                AABBUtils.box16(main, 4.0, 2.0, 4.0, 12.0, 4.0, 12.0);
            }
            if (x == 5 && z == 3) {
                s = true;
                w = true;
                e = true;
                hX = true;
                AABBUtils.box16(main, 4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
            }
        }
        if (y == 8) {
            if (x == 1 && z == 4) {
                w = true;
                e = true;
                hX = true;
            }
            if (x == 0 && z == 3) {
                s = true;
                n = true;
                hZ = true;
            }
        }
        if (v) {
            AABBUtils.box16(main, 4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
        }
        if (hX) {
            AABBUtils.box16(main, 0.0, 4.0, 4.0, 16.0, 12.0, 12.0);
        }
        if (hZ) {
            AABBUtils.box16(main, 4.0, 4.0, 0.0, 12.0, 12.0, 16.0);
        }
        if (y == 0) {
            if (x == 4 && z == 2) {
                w = true;
                u = true;
                AABBUtils.box16(main, 2.0, 4.0, 4.0, 12.0, 14.0, 12.0);
            }
            if (x == 3 && z == 2) {
                s = true;
                e = true;
                AABBUtils.box16(main, 4.0, 4.0, 4.0, 14.0, 12.0, 14.0);
            }
        }
        if (y == 2) {
            if (x == 2 && z == 3) {
                e = true;
                n = true;
                AABBUtils.box16(main, 4.0, 4.0, 2.0, 14.0, 12.0, 12.0);
            }
            if (x == 5 && z == 4) {
                n = true;
                d = true;
                AABBUtils.box16(main, 4.0, 2.0, 2.0, 12.0, 12.0, 12.0);
            }
            if (x == 6 && z == 3) {
                n = true;
                w = true;
                AABBUtils.box16(main, 2.0, 4.0, 2.0, 12.0, 12.0, 12.0);
            }
        }
        if (y == 8) {
            if (x == 0 && z == 2) {
                s = true;
                u = true;
                AABBUtils.box16(main, 4.0, 4.0, 4.0, 12.0, 14.0, 14.0);
            }
            if (x == 0 && z == 4) {
                e = true;
                n = true;
                AABBUtils.box16(main, 4.0, 4.0, 2.0, 14.0, 12.0, 12.0);
            }
            if (x == 2 && z == 4) {
                w = true;
                d = true;
                AABBUtils.box16(main, 2.0, 2.0, 4.0, 12.0, 12.0, 12.0);
            }
        }
        if (u) {
            AABBUtils.box16(main, 2.0, 14.0, 2.0, 14.0, 16.0, 14.0);
        }
        if (d) {
            AABBUtils.box16(main, 2.0, 0.0, 2.0, 14.0, 2.0, 14.0);
        }
        if (n) {
            AABBUtils.box16(main, 2.0, 2.0, 0.0, 14.0, 14.0, 2.0);
        }
        if (s) {
            AABBUtils.box16(main, 2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        }
        if (e) {
            AABBUtils.box16(main, 14.0, 2.0, 2.0, 16.0, 14.0, 14.0);
        }
        if (w) {
            AABBUtils.box16(main, 0.0, 2.0, 2.0, 2.0, 14.0, 14.0);
        }
        if (x == 1 && z == 4) {
            if (y == 0) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
                AABBUtils.box16(main, 12.0, 0.0, 10.0, 14.0, 16.0, 14.0);
                AABBUtils.box16(main, 2.0, 0.0, 10.0, 4.0, 16.0, 14.0);
            }
            if (y == 1) {
                AABBUtils.box16(main, 0.0, 0.0, 8.0, 16.0, 16.0, 16.0);
            }
        }
        if (y == 1 && z == 4 && (x == 6 || x == 7)) {
            AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 14.0);
            AABBUtils.box16(main, 4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
        }
        if (x == 6 && y == 2 && z == 4 || y >= 4 && y <= 13 && x == 4 && z == 2) {
            AABBUtils.box16(main, 5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
        }
        if (y == 1 && x == 3 && z == 4) {
            AABBUtils.box16(main, 0.0, 15.0, 14.0, 16.0, 17.0, 16.0);
            AABBUtils.box16(main, 1.0, 1.0, 14.0, 15.0, 15.0, 15.0);
        }
        if (x == 8 && z == 2 && y >= 5 && y <= 13) {
            AABBUtils.box16(main, 0.0, 0.0, 2.0, 1.0, 16.0, 14.0);
        }
        if (x == 7 && z == 2 && y >= 15 && y <= 21) {
            AABBUtils.box16(main, 0.0, 0.0, 2.0, 1.0, 16.0, 14.0);
        }
        if (y == 0 && (z != 0 && z != 4 || x != 0 && x != 4 && x != 8) && (z != 4 || x != 2 && x != 3 && (x < 5 || x > 7))) {
            AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
        }
        if (y >= 4 && y <= 13) {
            if (x == 1 || x == 5) {
                if (z == 1) {
                    List.of(AABBUtils.box16(1.0, 0.0, 1.0, 16.0, 16.0, 16.0));
                }
                if (z == 2) {
                    List.of(AABBUtils.box16(1.0, 0.0, 0.0, 16.0, 16.0, 16.0));
                }
                if (z == 3) {
                    List.of(AABBUtils.box16(1.0, 0.0, 0.0, 16.0, 16.0, 15.0));
                }
            }
            if (x == 2 || x == 6) {
                if (z == 1) {
                    List.of(AABBUtils.box16(0.0, 0.0, 1.0, 16.0, 16.0, 16.0));
                }
                if (z == 3) {
                    List.of(AABBUtils.box16(0.0, 0.0, 0.0, 16.0, 16.0, 15.0));
                }
            }
            if (x == 3 || x == 7) {
                if (z == 1) {
                    List.of(AABBUtils.box16(0.0, 0.0, 1.0, 15.0, 16.0, 16.0));
                }
                if (z == 2) {
                    List.of(AABBUtils.box16(0.0, 0.0, 0.0, 15.0, 16.0, 16.0));
                }
                if (z == 3) {
                    List.of(AABBUtils.box16(0.0, 0.0, 0.0, 15.0, 16.0, 15.0));
                }
            }
        }
        if (y == 0 || y == 1) {
            if (z >= 1 && z <= 3) {
                if (x == 0) {
                    AABBUtils.box16(main, 6.0, 0.0, 0.0, 7.0, 16.0, 16.0);
                }
                if (x == 8) {
                    AABBUtils.box16(main, 9.0, 0.0, 0.0, 10.0, 16.0, 16.0);
                }
            }
            if ((x >= 1 && x <= 3 || x >= 5 && x <= 7) && z == 0) {
                AABBUtils.box16(main, 0.0, 0.0, 6.0, 16.0, 16.0, 7.0);
            }
        }
        if (main.isEmpty()) {
            main.add(AABBUtils.FULL);
        }
        return main;
    }

    public static enum Inventory {
        INPUT,
        INPUT_FILLED,
        INPUT_EMPTY,
        OUTPUT_EMPTY,
        OUTPUT_FILLED;


        public int id() {
            return this.ordinal();
        }
    }

    public static class CokingChamber {
        @Nullable
        CokerUnitRecipe recipe = null;
        CokingState state = CokingState.STANDBY;
        FluidTank tank;
        int capacity;
        int inputAmount = 0;
        int outputAmount = 0;
        int timer = 0;

        public CokingChamber(int itemCapacity, int fluidCapacity) {
            this.capacity = itemCapacity;
            this.tank = new FluidTank(fluidCapacity);
        }

        public CokingChamber readFromNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.timer = nbt.m_128451_("timer");
            this.inputAmount = nbt.m_128451_("input");
            this.outputAmount = nbt.m_128451_("output");
            this.state = CokingState.values()[nbt.m_128451_("state")];
            if (nbt.m_128425_("recipe", 8)) {
                try {
                    this.recipe = CokerUnitRecipe.recipes.get(new ResourceLocation(nbt.m_128461_("recipe")));
                }
                catch (ResourceLocationException e) {
                    ImmersivePetroleum.log.error("Tried to load a coking recipe with an invalid name", (Throwable)e);
                }
            } else {
                this.recipe = null;
            }
            return this;
        }

        public CompoundTag writeToNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128405_("timer", this.timer);
            nbt.m_128405_("input", this.inputAmount);
            nbt.m_128405_("output", this.outputAmount);
            nbt.m_128405_("state", this.state.id());
            if (this.recipe != null) {
                nbt.m_128359_("recipe", this.recipe.m_6423_().toString());
            }
            return nbt;
        }

        public boolean setRecipe(@Nullable CokerUnitRecipe recipe) {
            if (this.state == CokingState.STANDBY) {
                this.recipe = recipe;
                return true;
            }
            return false;
        }

        public int addStack(@Nonnull ItemStack stack, boolean simulate) {
            if (this.recipe != null && !stack.m_41619_() && this.recipe.inputItem.test(stack)) {
                int capacity = this.getCapacity() * this.recipe.inputItem.getCount();
                int current = this.getTotalAmount() * this.recipe.inputItem.getCount();
                if (simulate) {
                    return Math.min(capacity - current, stack.m_41613_());
                }
                int filled = capacity - current;
                if (stack.m_41613_() < filled) {
                    filled = stack.m_41613_();
                }
                ++this.inputAmount;
                return filled;
            }
            return 0;
        }

        public CokingState getState() {
            return this.state;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getInputAmount() {
            return this.inputAmount;
        }

        public int getOutputAmount() {
            return this.outputAmount;
        }

        public int getTotalAmount() {
            return this.inputAmount + this.outputAmount;
        }

        public int getTimer() {
            return this.timer;
        }

        private boolean setStage(CokingState state) {
            if (this.state != state) {
                this.state = state;
                return true;
            }
            return false;
        }

        @Nullable
        public CokerUnitRecipe getRecipe() {
            return this.recipe;
        }

        public ItemStack getInputItem() {
            if (this.recipe == null) {
                return ItemStack.f_41583_;
            }
            return this.recipe.inputItem.getMatchingStacks()[0];
        }

        public ItemStack getOutputItem() {
            if (this.recipe == null) {
                return ItemStack.f_41583_;
            }
            return ((ItemStack)this.recipe.outputItem.get()).m_41777_();
        }

        public FluidTank getTank() {
            return this.tank;
        }

        public boolean tick(CokerUnitTileEntity cokerunit, int chamberId) {
            if (this.recipe == null) {
                return this.setStage(CokingState.STANDBY);
            }
            switch (this.state) {
                case STANDBY: {
                    if (this.recipe == null) break;
                    return this.setStage(CokingState.PROCESSING);
                }
                case PROCESSING: {
                    if (this.inputAmount <= 0 || this.getInputItem().m_41619_() || this.tank.getCapacity() - this.tank.getFluidAmount() < this.recipe.outputFluid.getAmount() || cokerunit.energyStorage.getEnergyStored() < this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime()) break;
                    cokerunit.energyStorage.extractEnergy(this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime(), false);
                    ++this.timer;
                    if (this.timer >= this.recipe.getTotalProcessTime() * this.recipe.inputItem.getCount()) {
                        this.timer = 0;
                        this.tank.fill(Utils.copyFluidStackWithAmount((FluidStack)this.recipe.outputFluid, (int)this.recipe.outputFluid.getAmount(), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        --this.inputAmount;
                        ++this.outputAmount;
                        if (this.inputAmount <= 0) {
                            this.setStage(CokingState.DRAIN_RESIDUE);
                        }
                    }
                    return true;
                }
                case DRAIN_RESIDUE: {
                    if (this.tank.getFluidAmount() > 0) {
                        FluidTank buffer = cokerunit.bufferTanks[1];
                        FluidStack drained = this.tank.drain(25, IFluidHandler.FluidAction.SIMULATE);
                        int accepted = buffer.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) break;
                        int amount = Math.min(drained.getAmount(), accepted);
                        this.tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        buffer.fill(Utils.copyFluidStackWithAmount((FluidStack)drained, (int)amount, (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                    return this.setStage(CokingState.FLOODING);
                }
                case FLOODING: {
                    ++this.timer;
                    if (this.timer < 2) break;
                    this.timer = 0;
                    int max = this.getTotalAmount() * this.recipe.inputFluid.getAmount();
                    if (this.tank.getFluidAmount() < max) {
                        FluidStack accepted = cokerunit.bufferTanks[0].drain(this.recipe.inputFluid.getAmount(), IFluidHandler.FluidAction.SIMULATE);
                        if (accepted.getAmount() < this.recipe.inputFluid.getAmount()) break;
                        cokerunit.bufferTanks[0].drain(this.recipe.inputFluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        this.tank.fill(accepted, IFluidHandler.FluidAction.EXECUTE);
                        break;
                    }
                    if (this.tank.getFluidAmount() < max) break;
                    return this.setStage(CokingState.DUMPING);
                }
                case DUMPING: {
                    boolean update = false;
                    ++this.timer;
                    if (this.timer >= 5) {
                        this.timer = 0;
                        if (this.outputAmount > 0) {
                            Level world = cokerunit.getLevelNonnull();
                            int amount = Math.min(this.outputAmount, 1);
                            ItemStack copy = ((ItemStack)this.recipe.outputItem.get()).m_41777_();
                            copy.m_41764_(amount);
                            BlockPos itemOutPos = cokerunit.getBlockPosForPos(chamberId == 0 ? Chamber_A_OUT : Chamber_B_OUT);
                            Vec3 center = new Vec3((double)itemOutPos.m_123341_() + 0.5, (double)itemOutPos.m_123342_() - 0.5, (double)itemOutPos.m_123343_() + 0.5);
                            ItemEntity ent = new ItemEntity(cokerunit.getLevelNonnull(), center.f_82479_, center.f_82480_, center.f_82481_, copy);
                            ent.m_20334_(0.0, 0.0, 0.0);
                            world.m_7967_((Entity)ent);
                            this.outputAmount -= amount;
                            update = true;
                        }
                    }
                    if (this.tank.getFluidAmount() > 0) {
                        this.tank.drain(25, IFluidHandler.FluidAction.EXECUTE);
                        update = true;
                    }
                    if (this.outputAmount <= 0 && this.tank.isEmpty()) {
                        this.recipe = null;
                        this.setStage(CokingState.STANDBY);
                        update = true;
                    }
                    if (!update) break;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum CokingState {
        STANDBY,
        PROCESSING,
        DRAIN_RESIDUE,
        FLOODING,
        DUMPING;


        public int id() {
            return this.ordinal();
        }
    }
}

