/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import flaxbeard.immersivepetroleum.common.util.survey.IslandInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SeismicSurveyTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile {
    public static final int DELAY = 10;
    public int timer = 0;
    @Nonnull
    public ItemStack stack = ItemStack.f_41583_;
    public boolean isSlave;

    public SeismicSurveyTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.SEISMIC_SURVEY.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void writeCustom(CompoundTag tag) {
        tag.m_128379_("slave", this.isSlave);
        tag.m_128405_("timer", this.timer);
        tag.m_128365_("stack", (Tag)this.stack.serializeNBT());
    }

    @Override
    protected void readCustom(CompoundTag tag) {
        this.isSlave = tag.m_128471_("slave");
        this.timer = tag.m_128451_("timer");
        this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        if (this.timer > 0) {
            --this.timer;
            this.m_6596_();
        }
    }

    public SeismicSurveyTileEntity master() {
        if (this.isSlave) {
            for (int i = 1; i < 3; ++i) {
                BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_7918_(0, -i, 0));
                if (!(te instanceof SeismicSurveyTileEntity)) continue;
                SeismicSurveyTileEntity seis = (SeismicSurveyTileEntity)te;
                if (seis.isSlave) continue;
                return seis;
            }
        }
        return this;
    }

    public boolean interact(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (this.timer > 0) {
            return false;
        }
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (player.m_6144_() && !this.stack.m_41619_()) {
            if (!world.f_46443_) {
                Utils.dropItemNoDelay(world, player.m_20183_().m_7494_(), this.stack);
                this.stack = ItemStack.f_41583_;
                this.m_6596_();
            }
            return true;
        }
        if (held.m_41619_()) {
            boolean fire = false;
            if (!this.stack.m_41619_()) {
                if (ExternalModContent.isIEItem_Buckshot(this.stack)) {
                    fire = true;
                    if (!world.f_46443_) {
                        this.timer = 10;
                        this.stack = new ItemStack((ItemLike)ExternalModContent.getIEItem_EmptyShell());
                        this.m_6596_();
                    }
                } else {
                    if (!world.f_46443_) {
                        Utils.dropItemNoDelay(world, player.m_20183_().m_7494_(), this.stack);
                        this.stack = ItemStack.f_41583_;
                        this.m_6596_();
                        double bX = (double)pos.m_123341_() + 0.5;
                        double bY = (double)pos.m_123342_() + 0.5;
                        double bZ = (double)pos.m_123343_() + 0.5;
                        world.m_6263_(null, bX, bY, bZ, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 0.25f);
                        world.m_6263_(null, bX, bY, bZ, SoundEvents.f_12167_, SoundSource.BLOCKS, 0.25f, 0.1f);
                    }
                    return true;
                }
            }
            if (fire) {
                if (world.f_46443_) {
                    double dst;
                    if (!player.m_7500_() && (dst = Math.sqrt(player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5))) < 4.0) {
                        double scale = 1.0 - Mth.m_14008_((double)(dst / 3.0), (double)0.0, (double)1.0);
                        player.f_20917_ = 40;
                        player.f_20916_ = 40 + (int)(30.0 * scale);
                        player.f_20918_ = Math.random() < 0.5 ? 180.0f : 0.0f;
                    }
                    double bX = (double)pos.m_123341_() + 0.5;
                    double bY = (double)pos.m_123342_() + 0.25;
                    double bZ = (double)pos.m_123343_() + 0.5;
                    double hSpeed = 0.05;
                    for (float i = 0.0f; i < 360.0f; i += 11.25f) {
                        double xa = Math.sin(Math.toRadians(i));
                        double za = Math.cos(Math.toRadians(i));
                        world.m_7106_((ParticleOptions)(Math.random() < 0.5 ? ParticleTypes.f_123762_ : ParticleTypes.f_123755_), bX + (xa *= 0.75), bY, bZ + (za *= 0.75), hSpeed * xa, 0.0, hSpeed * za);
                    }
                } else {
                    SoundEvent sound = ((BulletItem)ExternalModContent.getIEItem_Buckshot()).getType().getSound();
                    if (sound == null) {
                        sound = (SoundEvent)IESounds.revolverFire.get();
                    }
                    double bX = (double)pos.m_123341_() + 0.5;
                    double bY = (double)pos.m_123342_() + 0.5;
                    double bZ = (double)pos.m_123343_() + 0.5;
                    double dst = Math.sqrt(player.m_20275_(bX, bY, bZ));
                    float volume = (float)(1.0 - Mth.m_14008_((double)(dst / 3.0), (double)0.0, (double)0.85));
                    world.m_6263_(null, bX, bY, bZ, sound, SoundSource.BLOCKS, volume, 0.5f);
                }
                if (!world.f_46443_) {
                    ISurveyInfo info;
                    ReservoirIsland currentIsland = ReservoirHandler.getIslandNoCache(world, pos);
                    ItemStack stack = new ItemStack((ItemLike)IPContent.Items.SURVEYRESULT.get());
                    if (currentIsland != null) {
                        info = new IslandInfo(world, pos, currentIsland);
                        if (((IslandInfo)info).getFluid().equals(IPContent.Fluids.CRUDEOIL.get())) {
                            Utils.unlockIPAdvancement(player, "main/root");
                        }
                    } else {
                        info = new SurveyScan(world, pos);
                    }
                    info.writeToStack(stack);
                    Utils.dropItemNoDelay(world, player.m_20183_().m_7494_(), stack);
                }
                return true;
            }
            return false;
        }
        if (ExternalModContent.isIEItem_Buckshot(held) && this.stack.m_41619_()) {
            if (!world.f_46443_) {
                ItemStack copy = held.m_41777_();
                copy.m_41764_(1);
                this.stack = copy;
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                    if (held.m_41619_()) {
                        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    }
                }
                this.m_6596_();
            }
            return true;
        }
        return false;
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }
}

