/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.render.dyn.DynamicTextureWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecipeReloadListener
implements ResourceManagerReloadListener {
    private final ReloadableServerResources dataPackRegistries;

    public RecipeReloadListener(ReloadableServerResources dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        if (this.dataPackRegistries != null) {
            RecipeReloadListener.lists(this.dataPackRegistries.m_206887_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void recipesUpdated(RecipesUpdatedEvent event) {
        if (!Minecraft.m_91087_().m_91091_()) {
            RecipeReloadListener.lists(event.getRecipeManager());
        }
        DynamicTextureWrapper.clearCache();
    }

    static void lists(RecipeManager recipeManager) {
        Collection recipes = recipeManager.m_44051_();
        if (recipes.size() == 0) {
            return;
        }
        ImmersivePetroleum.log.info("Loading Distillation Recipes.");
        DistillationTowerRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, DistillationTowerRecipe.class, IPRecipeTypes.DISTILLATION);
        ImmersivePetroleum.log.info("Loading Reservoirs.");
        ReservoirType.map = RecipeReloadListener.filterRecipes(recipes, ReservoirType.class, IPRecipeTypes.RESERVOIR);
        ImmersivePetroleum.log.info("Loading Coker-Unit Recipes.");
        CokerUnitRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, CokerUnitRecipe.class, IPRecipeTypes.COKER);
        ImmersivePetroleum.log.info("Loading High-Pressure Refinery Recipes.");
        HighPressureRefineryRecipe.recipes = RecipeReloadListener.filterRecipes(recipes, HighPressureRefineryRecipe.class, IPRecipeTypes.HYDROTREATER);
    }

    static <R extends Recipe<?>> Map<ResourceLocation, R> filterRecipes(Collection<Recipe<?>> recipes, Class<R> recipeClass, IERecipeTypes.TypeWithClass<R> recipeType) {
        return recipes.stream().filter(iRecipe -> iRecipe.m_6671_() == recipeType.get()).map(recipeClass::cast).collect(Collectors.toMap(recipe -> recipe.m_6423_(), recipe -> recipe));
    }
}

