/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.gantry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import com.simibubi.create.content.contraptions.render.NonStationaryLighter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GantryContraption
extends TranslatingContraption {
    protected Direction facing;

    public GantryContraption() {
    }

    public GantryContraption(Direction facing) {
        this.facing = facing;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        this.startMoving(world);
        return true;
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("Facing", this.facing.m_122411_());
        return tag;
    }

    @Override
    public void readNBT(Level world, CompoundTag tag, boolean spawnData) {
        this.facing = Direction.m_122376_((int)tag.m_128451_("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return super.isAnchoringBlockAt(pos.m_121945_(this.facing));
    }

    @Override
    public ContraptionType getType() {
        return ContraptionType.GANTRY;
    }

    public Direction getFacing() {
        return this.facing;
    }

    @Override
    protected boolean shouldUpdateAfterMovement(StructureTemplate.StructureBlockInfo info) {
        return super.shouldUpdateAfterMovement(info) && !AllBlocks.GANTRY_CARRIAGE.has(info.f_74676_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new NonStationaryLighter<GantryContraption>(this);
    }
}

