/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.world;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.register.IEBannerPatterns;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.mixin.accessors.HeroGiftsTaskAccess;
import blusunrize.immersiveengineering.mixin.accessors.SingleJigsawAccess;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Villages {
    public static final ResourceLocation ENGINEER = ImmersiveEngineering.rl("engineer");
    public static final ResourceLocation MACHINIST = ImmersiveEngineering.rl("machinist");
    public static final ResourceLocation ELECTRICIAN = ImmersiveEngineering.rl("electrician");
    public static final ResourceLocation OUTFITTER = ImmersiveEngineering.rl("outfitter");
    public static final ResourceLocation GUNSMITH = ImmersiveEngineering.rl("gunsmith");
    private static final TradeOutline EMERALD_FOR_ITEM = (buying, priceInfo, random, maxUses, xp, priceMultiplier) -> new MerchantOffer(ItemHandlerHelper.copyStackWithSize((ItemStack)buying, (int)priceInfo.getPrice(random)), new ItemStack((ItemLike)Items.f_42616_), maxUses, xp, priceMultiplier);
    private static final TradeOutline ONE_ITEM_FOR_EMERALDS = (selling, priceInfo, random, maxUses, xp, priceMultiplier) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, priceInfo.getPrice(random)), selling, maxUses, xp, priceMultiplier);
    private static final TradeOutline ITEMS_FOR_ONE_EMERALD = (selling, priceInfo, random, maxUses, xp, priceMultiplier) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemHandlerHelper.copyStackWithSize((ItemStack)selling, (int)priceInfo.getPrice(random)), maxUses, xp, priceMultiplier);

    public static void init() {
        PlainVillagePools.m_127185_();
        SnowyVillagePools.m_127233_();
        SavannaVillagePools.m_127230_();
        DesertVillagePools.m_126860_();
        TaigaVillagePools.m_127305_();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            for (String type : new String[]{"engineer", "machinist", "electrician", "gunsmith", "outfitter"}) {
                Villages.addToPool(new ResourceLocation("village/" + biome + "/houses"), ImmersiveEngineering.rl("village/houses/" + biome + "_" + type), 1);
            }
        }
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ENGINEER.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/engineer"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_MACHINIST.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/machinist"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ELECTRICIAN.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/electrician"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_OUTFITTER.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/outfitter"));
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_GUNSMITH.get(), ImmersiveEngineering.rl("gameplay/hero_of_the_village/gunsmith"));
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        StructureTemplatePool old = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        int id = BuiltinRegistries.f_123864_.m_7447_((Object)old);
        List shuffled = old != null ? old.m_227362_(RandomSource.m_216335_((long)0L)) : ImmutableList.of();
        Object2IntLinkedOpenHashMap newPieces = new Object2IntLinkedOpenHashMap();
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext()) {
            StructurePoolElement p = (StructurePoolElement)iterator.next();
            newPieces.computeInt((Object)p, (pTemp, i) -> (i == null ? 0 : i) + 1);
        }
        newPieces.put((Object)SingleJigsawAccess.construct((Either<ResourceLocation, StructureTemplate>)Either.left((Object)toAdd), (Holder<StructureProcessorList>)ProcessorLists.f_127198_, StructureTemplatePool.Projection.RIGID), weight);
        List newPieceList = newPieces.object2IntEntrySet().stream().map(e -> Pair.of((Object)((StructurePoolElement)e.getKey()), (Object)e.getIntValue())).collect(Collectors.toList());
        ResourceLocation name = old.m_210587_();
        ((WritableRegistry)BuiltinRegistries.f_123864_).m_203384_(OptionalInt.of(id), ResourceKey.m_135785_((ResourceKey)BuiltinRegistries.f_123864_.m_123023_(), (ResourceLocation)name), (Object)new StructureTemplatePool(pool, name, newPieceList), Lifecycle.stable());
    }

    @Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registers {
        public static final DeferredRegister<PoiType> POINTS_OF_INTEREST = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"immersiveengineering");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"immersiveengineering");
        public static final RegistryObject<PoiType> POI_CRAFTINGTABLE = POINTS_OF_INTEREST.register("craftingtable", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.CRAFTING_TABLE.get())));
        public static final RegistryObject<PoiType> POI_TURNTABLE = POINTS_OF_INTEREST.register("turntable", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.TURNTABLE.get())));
        public static final RegistryObject<PoiType> POI_CIRCUITTABLE = POINTS_OF_INTEREST.register("circuit_table", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.CIRCUIT_TABLE.get())));
        public static final RegistryObject<PoiType> POI_BANNER = POINTS_OF_INTEREST.register("shaderbanner", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.Cloth.SHADER_BANNER.get())));
        public static final RegistryObject<PoiType> POI_WORKBENCH = POINTS_OF_INTEREST.register("workbench", () -> Registers.createPOI(Registers.assembleStates(IEBlocks.WoodenDevices.WORKBENCH.get())));
        public static final RegistryObject<VillagerProfession> PROF_ENGINEER = PROFESSIONS.register(ENGINEER.m_135815_(), () -> Registers.createProf(ENGINEER, POI_TURNTABLE, SoundEvents.f_12572_));
        public static final RegistryObject<VillagerProfession> PROF_MACHINIST = PROFESSIONS.register(MACHINIST.m_135815_(), () -> Registers.createProf(MACHINIST, POI_CRAFTINGTABLE, SoundEvents.f_12574_));
        public static final RegistryObject<VillagerProfession> PROF_ELECTRICIAN = PROFESSIONS.register(ELECTRICIAN.m_135815_(), () -> Registers.createProf(ELECTRICIAN, POI_CIRCUITTABLE, (SoundEvent)IESounds.spark.get()));
        public static final RegistryObject<VillagerProfession> PROF_OUTFITTER = PROFESSIONS.register(OUTFITTER.m_135815_(), () -> Registers.createProf(OUTFITTER, POI_BANNER, SoundEvents.f_12565_));
        public static final RegistryObject<VillagerProfession> PROF_GUNSMITH = PROFESSIONS.register(GUNSMITH.m_135815_(), () -> Registers.createProf(GUNSMITH, POI_WORKBENCH, (SoundEvent)IESounds.revolverReload.get()));

        private static PoiType createPOI(Collection<BlockState> block) {
            return new PoiType((Set)ImmutableSet.copyOf(block), 1, 1);
        }

        private static VillagerProfession createProf(ResourceLocation name, RegistryObject<PoiType> poi, SoundEvent sound) {
            ResourceKey poiName = Objects.requireNonNull(poi.getKey());
            return new VillagerProfession(name.toString(), holder -> holder.m_203565_(poiName), holder -> holder.m_203565_(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
        }

        private static Collection<BlockState> assembleStates(Block block) {
            return block.m_49965_().m_61056_().stream().filter(blockState -> {
                if (blockState.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE)) {
                    return (Boolean)blockState.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE) == false;
                }
                return true;
            }).collect(Collectors.toList());
        }
    }

    private record PriceInterval(int min, int max) {
        int getPrice(RandomSource rand) {
            return this.min >= this.max ? this.min : this.min + rand.m_188503_(this.max - this.min + 1);
        }
    }

    @FunctionalInterface
    private static interface TradeOutline {
        public MerchantOffer generateOffer(ItemStack var1, PriceInterval var2, RandomSource var3, int var4, int var5, float var6);
    }

    private static class LazyItemStack
    implements Function<Level, ItemStack> {
        private final Function<Level, ItemStack> function;
        private ItemStack instance;

        private LazyItemStack(Function<Level, ItemStack> function) {
            this.function = function;
        }

        @Override
        public ItemStack apply(Level level) {
            if (this.instance == null) {
                this.instance = this.function.apply(level);
            }
            return this.instance;
        }
    }

    private static class RevolverPieceForEmeralds
    implements VillagerTrades.ItemListing {
        public MerchantOffer m_213663_(Entity trader, @Nonnull RandomSource random) {
            AbstractVillager villager;
            int part = random.m_188503_(3);
            ItemStack stack = new ItemStack(part == 0 ? IEItems.Ingredients.GUNPART_BARREL : (part == 1 ? IEItems.Ingredients.GUNPART_DRUM : IEItems.Ingredients.GUNPART_HAMMER));
            float luck = 1.0f;
            if (trader instanceof AbstractVillager && (villager = (AbstractVillager)trader).m_35306_()) {
                luck = villager.m_7962_().m_36336_();
            }
            CompoundTag perksTag = RevolverItem.RevolverPerk.generatePerkSet(random, luck);
            ItemNBTHelper.setTagCompound(stack, "perks", perksTag);
            int tier = Math.max(1, RevolverItem.RevolverPerk.calculateTier(perksTag));
            ItemNBTHelper.putBoolean(stack, "generatePerks", true);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5 * tier + random.m_188503_(5)), stack, 1, 45, 0.25f);
        }
    }

    private static class OreveinMapForEmeralds
    implements VillagerTrades.ItemListing {
        public PriceInterval value;
        private static final int SEARCH_RADIUS = 256;
        private static final String TRADER_SOLD_KEY = "immersiveengineering:mapped_veins";

        @Nullable
        public MerchantOffer m_213663_(@Nullable Entity trader, @Nonnull RandomSource random) {
            List<MineralVein> veins;
            if (trader == null) {
                return null;
            }
            Level world = trader.m_20193_();
            BlockPos merchantPos = trader.m_20183_();
            CompoundTag traderData = trader.getPersistentData();
            ArrayList<Long> soldMaps = new ArrayList<Long>();
            if (traderData.m_128441_(TRADER_SOLD_KEY)) {
                for (long l : traderData.m_128467_(TRADER_SOLD_KEY)) {
                    soldMaps.add(l);
                }
            }
            if ((veins = ExcavatorHandler.findVeinsForVillager(world, merchantPos, 256L, soldMaps)).size() > 0) {
                int select = random.m_188503_(Math.min(10, veins.size()));
                MineralVein vein = veins.get(select);
                ColumnPos veinPos = vein.getPos();
                soldMaps.add(veinPos.m_143200_());
                traderData.m_128428_(TRADER_SOLD_KEY, soldMaps);
                BlockPos blockPos = new BlockPos(veinPos.f_140723_(), 64, veinPos.f_140724_());
                ItemStack selling = MapItem.m_42886_((Level)world, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)1, (boolean)true, (boolean)true);
                MapItem.m_42897_((Level)world, (ItemStack)selling);
                MapItemSavedData.m_77925_((ItemStack)selling, (BlockPos)blockPos, (String)"ie:coresample_treasure", (MapDecoration.Type)MapDecoration.Type.RED_X);
                selling.m_41714_((Component)Component.m_237115_((String)"item.immersiveengineering.map_orevein"));
                ItemNBTHelper.setLore(selling, new Component[]{Component.m_237115_((String)vein.getMineral(world).getTranslationKey())});
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 8 + random.m_188503_(8)), new ItemStack((ItemLike)Items.f_42522_), selling, 0, 1, 30, 0.5f);
            }
            return null;
        }
    }

    private static class TradeListing
    implements VillagerTrades.ItemListing {
        private final TradeOutline outline;
        private final LazyItemStack lazyItem;
        private final PriceInterval priceInfo;
        private final int maxUses;
        private final int xp;
        private float priceMultiplier = 0.05f;

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull Function<Level, ItemStack> item, @Nonnull PriceInterval priceInfo, int maxUses, int xp) {
            this.outline = outline;
            this.lazyItem = new LazyItemStack(item);
            this.priceInfo = priceInfo;
            this.maxUses = maxUses;
            this.xp = xp;
        }

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull ItemStack itemStack, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(outline, (Level l) -> itemStack, buyAmounts, maxUses, xp);
        }

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull ItemLike item, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(outline, new ItemStack(item), buyAmounts, maxUses, xp);
        }

        public TradeListing(@Nonnull TradeOutline outline, @Nonnull TagKey<Item> tag, @Nonnull PriceInterval buyAmounts, int maxUses, int xp) {
            this(outline, (Level l) -> l != null ? IEApi.getPreferredTagStack(l.m_5962_(), tag) : ItemStack.f_41583_, buyAmounts, maxUses, xp);
        }

        public TradeListing setMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        @Nullable
        public MerchantOffer m_213663_(@Nullable Entity trader, @Nonnull RandomSource rand) {
            ItemStack buying = this.lazyItem.apply(trader != null ? trader.f_19853_ : null);
            return this.outline.generateOffer(buying, this.priceInfo, rand, this.maxUses, this.xp, this.priceMultiplier);
        }
    }

    @Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent ev) {
            Int2ObjectMap trades = ev.getTrades();
            ResourceLocation typeName = new ResourceLocation(ev.getType().f_35600_());
            if (ENGINEER.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getItemTag(IETags.treatedWood), new PriceInterval(4, 6), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING, new PriceInterval(5, 8), 16, 1));
                ((List)trades.get(1)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.Cloth.BALLOON, new PriceInterval(1, 3), 12, 2));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.ironRod, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.ironRod, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(2, 4), 12, 5));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.MetalDecoration.ALU_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD), new PriceInterval(2, 4), 12, 5));
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.STRUCTURE_ROPE), new PriceInterval(4, 6), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.Connectors.CONNECTOR_STRUCTURAL, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.StoneDecoration.CONCRETE, new PriceInterval(4, 8), 8, 15));
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.StoneDecoration.CONCRETE_LEADED, new PriceInterval(4, 6), 16, 10));
                ((List)trades.get(4)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEBlocks.WoodenDecoration.TREATED_POST, new PriceInterval(2, 3), 8, 20));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.StoneDecoration.INSULATING_GLASS, new PriceInterval(2, 6), 16, 10));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.StoneDecoration.DUROPLAST, new PriceInterval(2, 6), 16, 10));
                ((List)trades.get(4)).add(new OreveinMapForEmeralds());
                ((List)trades.get(5)).add(new OreveinMapForEmeralds());
            } else if (MACHINIST.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.coalCoke, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.HAMMER, new PriceInterval(1, 3), 12, 1).setMultiplier(0.2f));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("components"), new PriceInterval(6, 16), 3, 5).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, new PriceInterval(3, 6), 12, 10));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.COMPONENT_STEEL, new PriceInterval(1, 3), 12, 5));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.WATERWHEEL_SEGMENT, new PriceInterval(1, 3), 8, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.TOOLBOX, new PriceInterval(6, 8), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.DRILLHEAD_IRON, new PriceInterval(20, 40), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.SAWBLADE, new PriceInterval(20, 40), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.EARMUFFS, new PriceInterval(4, 9), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.DRILLHEAD_STEEL, new PriceInterval(32, 48), 3, 30).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_LUBE), new PriceInterval(5, 10), 8, 10));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_CAPACITY), new PriceInterval(5, 10), 8, 10));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEBlocks.MetalDecoration.ENGINEERING_LIGHT, new PriceInterval(1, 2), 16, 10));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.DRILL_FORTUNE), new PriceInterval(5, 10), 8, 10));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("electrode"), new PriceInterval(12, 24), 3, 30).setMultiplier(0.2f));
            } else if (ELECTRICIAN.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.copperWire, new PriceInterval(8, 16), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.COPPER), new PriceInterval(2, 4), 16, 1));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.WIRECUTTER, new PriceInterval(1, 3), 12, 1).setMultiplier(0.2f));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.SCREWDRIVER, new PriceInterval(1, 3), 12, 1).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.electrumWire, new PriceInterval(6, 12), 16, 5));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.ELECTRUM), new PriceInterval(1, 4), 16, 5));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Tools.VOLTMETER, new PriceInterval(1, 3), 12, 5).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.FEET), new PriceInterval(5, 7), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.LEGS), new PriceInterval(9, 11), 3, 15).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.aluminumWire, new PriceInterval(4, 8), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, IEItems.Misc.WIRE_COILS.get(WireType.STEEL), new PriceInterval(1, 2), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.CHEST), new PriceInterval(11, 15), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FARADAY_SUIT.get(EquipmentSlot.HEAD), new PriceInterval(5, 7), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.ELECTRON_TUBE, new PriceInterval(2, 6), 16, 10));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.COMPONENT_ELECTRONIC, new PriceInterval(1, 3), 16, 15));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Misc.FLUORESCENT_TUBE, new PriceInterval(3, 6), 3, 20).setMultiplier(0.2f));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBlocks.MetalDevices.TESLA_COIL, new PriceInterval(20, 32), 12, 30));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.CIRCUIT_BOARD, new PriceInterval(1, 2), 16, 5));
            } else if (OUTFITTER.equals((Object)typeName)) {
                ItemLike bag_common = IEItems.Misc.SHADER_BAG.get(Rarity.COMMON);
                ItemLike bag_uncommon = IEItems.Misc.SHADER_BAG.get(Rarity.UNCOMMON);
                ItemLike bag_rare = IEItems.Misc.SHADER_BAG.get(Rarity.RARE);
                ItemLike bag_epic = IEItems.Misc.SHADER_BAG.get(Rarity.EPIC);
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_common, new PriceInterval(1, 8), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.HEMP_FABRIC, new PriceInterval(8, 12), 16, 1));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_uncommon, new PriceInterval(4, 12), 16, 5));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBannerPatterns.HAMMER.item(), new PriceInterval(10, 20), 3, 20));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBannerPatterns.WINDMILL.item(), new PriceInterval(4, 20), 3, 20));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEBannerPatterns.ORNATE.item(), new PriceInterval(4, 20), 3, 20));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_rare, new PriceInterval(8, 16), 16, 15));
                ((List)trades.get(3)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getTagsFor((EnumMetals)EnumMetals.SILVER).dust, new PriceInterval(4, 12), 16, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_uncommon, new PriceInterval(4, 12), 8, 5));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_epic, new PriceInterval(12, 20), 3, 20));
                ((List)trades.get(4)).add(new TradeListing(EMERALD_FOR_ITEM, IETags.getTagsFor((EnumMetals)EnumMetals.GOLD).dust, new PriceInterval(4, 12), 16, 15));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_rare, new PriceInterval(8, 16), 8, 15));
                ((List)trades.get(5)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, bag_epic, new PriceInterval(16, 28), 3, 30).setMultiplier(0.2f));
            } else if (GUNSMITH.equals((Object)typeName)) {
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.EMPTY_CASING, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(EMERALD_FOR_ITEM, IEItems.Ingredients.EMPTY_SHELL, new PriceInterval(6, 12), 16, 2));
                ((List)trades.get(1)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, IEItems.Ingredients.WOODEN_GRIP, new PriceInterval(2, 4), 1, 12).setMultiplier(0.2f));
                ((List)trades.get(2)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("bullet"), new PriceInterval(3, 6), 1, 25));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(BulletItem.CASULL), new PriceInterval(2, 4), 12, 5));
                ((List)trades.get(2)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(BulletItem.BUCKSHOT), new PriceInterval(2, 6), 12, 5));
                ((List)trades.get(2)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(3)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(3)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(BulletItem.FLARE), new PriceInterval(1, 2), 12, 10));
                ((List)trades.get(3)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BlueprintCraftingRecipe.getTypedBlueprint("specialBullet"), new PriceInterval(5, 9), 1, 30).setMultiplier(0.2f));
                ((List)trades.get(4)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(4)).add(new TradeListing(ITEMS_FOR_ONE_EMERALD, BulletHandler.getBulletStack(BulletItem.SILVER), new PriceInterval(1, 4), 8, 15));
                ((List)trades.get(4)).add(new TradeListing(ONE_ITEM_FOR_EMERALDS, BulletHandler.getBulletStack(BulletItem.HIGH_EXPLOSIVE), new PriceInterval(2, 4), 8, 15));
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
                ((List)trades.get(5)).add(new RevolverPieceForEmeralds());
            }
        }
    }
}

