/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.init;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.forge.config.NightConfigFixer;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;

public class ModernFixClientForge {
    private static ModernFixClient commonMod;
    private KeyMapping configKey;
    private static final List<String> brandingList;

    public ModernFixClientForge() {
        commonMod = new ModernFixClient();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::keyBindRegister);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ModernFixConfigScreen((Screen)screen)));
    }

    private void keyBindRegister(RegisterKeyMappingsEvent event) {
        this.configKey = new KeyMapping("key.modernfix.config", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.f_84822_, "key.modernfix");
        event.register(this.configKey);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        if (ModernFixMixinPlugin.instance.isOptionEnabled("perf.dynamic_resources.ConnectednessCheck") && ModList.get().isLoaded("connectedness")) {
            event.enqueueWork(() -> ModLoader.get().addWarning(new ModLoadingWarning(ModLoadingContext.get().getActiveContainer().getModInfo(), ModLoadingStage.SIDED_SETUP, "modernfix.connectedness_dynresoruces", new Object[0])));
        }
    }

    @SubscribeEvent
    public void onConfigKey(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.configKey != null && this.configKey.m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new ModernFixConfigScreen(Minecraft.m_91087_().f_91080_));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onClientChat(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"mfrc").executes(context -> {
            NightConfigFixer.runReloads();
            return 1;
        }));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderOverlay(CustomizeGuiOverlayEvent.DebugText event) {
        if (ModernFixClientForge.commonMod.brandingString != null && Minecraft.m_91087_().f_91066_.f_92063_) {
            int targetIdx;
            if (brandingList.size() == 0) {
                brandingList.add("");
                brandingList.add(ModernFixClientForge.commonMod.brandingString);
            }
            int numSeenBlanks = 0;
            ArrayList right = event.getRight();
            for (targetIdx = 0; targetIdx < right.size(); ++targetIdx) {
                String s = (String)right.get(targetIdx);
                if (s == null || s.length() == 0) {
                    ++numSeenBlanks;
                }
                if (numSeenBlanks == 3) break;
            }
            right.addAll(targetIdx, brandingList);
        }
    }

    @SubscribeEvent
    public void onDisconnect(LevelEvent.Unload event) {
        DebugScreenOverlay overlay;
        if (event.getLevel().m_5776_() && (overlay = (DebugScreenOverlay)ObfuscationReflectionHelper.getPrivateValue(ForgeGui.class, (Object)((ForgeGui)Minecraft.m_91087_().f_91065_), (String)"debugOverlay")) != null) {
            Minecraft.m_91087_().m_6937_(() -> ((DebugScreenOverlay)overlay).m_94040_());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartedEvent event) {
        commonMod.onServerStarted(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            commonMod.onRenderTickEnd();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRecipes(RecipesUpdatedEvent e) {
        commonMod.onRecipesUpdated();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTags(TagsUpdatedEvent e) {
        commonMod.onTagsUpdated();
    }

    static {
        brandingList = new ArrayList<String>();
    }
}

