/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.util.WineYears;

public class DrinkBlockItem
extends BlockItem {
    public DrinkBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    protected BlockState m_5965_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player != null && !player.m_6047_()) {
            BlockState blockState = this.m_40614_().m_5573_(context);
            return blockState != null && this.m_40610_(context, blockState) ? blockState : null;
        }
        return null;
    }

    protected boolean m_7274_(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity;
        if (level != null && player != null && (blockEntity = level.m_7702_(blockPos)) instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)blockEntity;
            ItemStack newStack = itemStack.m_41777_();
            newStack.m_41764_(1);
            wineEntity.setStack(0, newStack);
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        ArrayList list2 = this.m_41473_() != null ? this.m_41473_().m_38749_() : Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        if (list2.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (Pair statusEffectInstance : list2) {
                MutableComponent mutableText = Component.m_237115_((String)((MobEffectInstance)statusEffectInstance.getFirst()).m_19576_());
                MobEffect statusEffect = ((MobEffectInstance)statusEffectInstance.getFirst()).m_19544_();
                Map map = statusEffect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier entityAttributeModifier = (AttributeModifier)entry.getValue();
                        AttributeModifier entityAttributeModifier2 = new AttributeModifier(entityAttributeModifier.m_22214_(), statusEffect.m_7048_(((MobEffectInstance)statusEffectInstance.getFirst()).m_19564_(), entityAttributeModifier), entityAttributeModifier.m_22217_());
                        list3.add(new Pair((Object)((Attribute)entry.getKey()), (Object)entityAttributeModifier2));
                    }
                }
                if (world != null) {
                    mutableText = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, Component.m_237115_((String)("potion.potency." + WineYears.getEffectLevel(stack, world)))});
                }
                if (((MobEffectInstance)statusEffectInstance.getFirst()).m_19557_() > 20) {
                    mutableText = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.m_19581_((MobEffectInstance)((MobEffectInstance)statusEffectInstance.getFirst()), (float)((Float)statusEffectInstance.getSecond()).floatValue())});
                }
                tooltip.add((Component)mutableText.m_130940_(statusEffect.m_19483_().m_19497_()));
            }
        }
        if (!list3.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list3) {
                AttributeModifier entityAttributeModifier3 = (AttributeModifier)pair.getSecond();
                double d = entityAttributeModifier3.m_22218_();
                double e = entityAttributeModifier3.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && entityAttributeModifier3.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? entityAttributeModifier3.m_22218_() : entityAttributeModifier3.m_22218_() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + entityAttributeModifier3.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(e), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + entityAttributeModifier3.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(e *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"block.vinery.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237115_((String)("item.vinery.wine." + this.m_5524_())).m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.vinery.year").m_130940_(ChatFormatting.WHITE).m_7220_(Component.m_130674_((String)(" " + WineYears.getWineYear(stack, world)))));
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        super.m_5922_(itemStack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, itemStack);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (itemStack.m_41619_()) {
            return new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get());
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!((Player)livingEntity).m_150110_().f_35937_) {
                ItemStack itemStack2 = new ItemStack((ItemLike)ObjectRegistry.WINE_BOTTLE.get());
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
            }
        }
        return itemStack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
    }
}

