/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.recipes.collect.RecipeTypeData;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeTypeDataMap {
    private final @Unmodifiable Map<ResourceLocation, RecipeTypeData<?>> uidMap;

    public RecipeTypeDataMap(List<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> recipeCategoryCatalystsMap) {
        this.uidMap = recipeCategories.stream().collect(Collectors.toUnmodifiableMap(recipeCategory -> recipeCategory.getRecipeType().getUid(), recipeCategory -> {
            ImmutableList catalysts = recipeCategoryCatalystsMap.get(recipeCategory);
            return new RecipeTypeData(recipeCategory, (List<ITypedIngredient<?>>)catalysts);
        }));
    }

    public <T> RecipeTypeData<T> get(RecipeType<T> recipeType) {
        RecipeTypeData<?> data;
        RecipeTypeData<?> recipeTypeData = data = this.uidMap.get(recipeType.getUid());
        return recipeTypeData;
    }

    public <T> RecipeTypeData<T> get(Iterable<? extends T> recipes, RecipeType<T> recipeType) {
        RecipeTypeData<T> recipeTypeData = this.get(recipeType);
        return RecipeTypeDataMap.validate(recipes, recipeTypeData);
    }

    private static <T> RecipeTypeData<T> validate(Iterable<? extends T> recipes, RecipeTypeData<?> recipeTypeData) {
        IRecipeCategory<?> recipeCategory = recipeTypeData.getRecipeCategory();
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        Class<?> recipeClass = recipeType.getRecipeClass();
        for (T recipe : recipes) {
            if (recipeClass.isInstance(recipe)) continue;
            throw new IllegalArgumentException(recipeType.getUid() + " recipes must be an instance of " + recipeClass + ". Instead got: " + recipe.getClass());
        }
        RecipeTypeData<?> castRecipeTypeData = recipeTypeData;
        return castRecipeTypeData;
    }

    public void validate(RecipeType<?> recipeType) {
        if (!this.uidMap.containsKey(recipeType.getUid())) {
            throw new IllegalStateException("There is no recipe type registered for: " + recipeType.getUid());
        }
    }

    public Optional<RecipeType<?>> getType(ResourceLocation recipeTypeUid) {
        RecipeTypeData<?> data = this.uidMap.get(recipeTypeUid);
        return Optional.ofNullable(data).map(RecipeTypeData::getRecipeCategory).map(IRecipeCategory::getRecipeType);
    }
}

