/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.item;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.QuarkModule;

public abstract class QuarkArrowItem
extends ArrowItem
implements IQuarkItem {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkArrowItem(String name, QuarkModule module) {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40757_));
        RegistryHelper.registerItem((Item)this, (String)name);
        this.module = module;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_6787_(group, items);
        }
    }

    @Override
    public QuarkArrowItem setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    public static class Impl
    extends QuarkArrowItem {
        private final ArrowCreator creator;

        public Impl(String name, QuarkModule module, ArrowCreator creator) {
            super(name, module);
            this.creator = creator;
        }

        public AbstractArrow m_6394_(Level p_40513_, ItemStack p_40514_, LivingEntity p_40515_) {
            return this.creator.createArrow(p_40513_, p_40514_, p_40515_);
        }

        public static interface ArrowCreator {
            public AbstractArrow createArrow(Level var1, ItemStack var2, LivingEntity var3);
        }
    }
}

