/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;
import vazkii.quark.base.module.config.type.IBiomeConfig;

public class BiomeTagConfig
extends AbstractConfigType
implements IBiomeConfig {
    private final Object mutex = new Object();
    @Config(name="Biome Tags")
    private List<String> biomeTagStrings;
    @Config
    private boolean isBlacklist;
    private List<TagKey<Biome>> tags;

    @SafeVarargs
    protected BiomeTagConfig(boolean isBlacklist, TagKey<Biome> ... tagsIn) {
        this.isBlacklist = isBlacklist;
        this.biomeTagStrings = new LinkedList<String>();
        for (TagKey<Biome> t : tagsIn) {
            this.biomeTagStrings.add(t.f_203868_().toString());
        }
    }

    private BiomeTagConfig(boolean isBlacklist, String ... types) {
        this.isBlacklist = isBlacklist;
        this.biomeTagStrings = new LinkedList<String>();
        this.biomeTagStrings.addAll(Arrays.asList(types));
    }

    protected static BiomeTagConfig fromStrings(boolean isBlacklist, String ... types) {
        return new BiomeTagConfig(isBlacklist, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSpawn(Holder<Biome> biome) {
        if (biome == null) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.tags == null) {
                this.updateTypes();
            }
            for (TagKey<Biome> tag : this.tags) {
                if (!biome.m_203656_(tag)) continue;
                return !this.isBlacklist;
            }
            return this.isBlacklist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload(QuarkModule module, ConfigFlagManager flagManager) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateTypes();
        }
    }

    public void updateTypes() {
        this.tags = new LinkedList<TagKey<Biome>>();
        for (String s : this.biomeTagStrings) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s));
            if (tag == null) continue;
            this.tags.add((TagKey<Biome>)tag);
        }
    }
}

