/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.util.VanillaWoods;
import vazkii.quark.content.building.block.LeafCarpetBlock;
import vazkii.quark.content.world.block.BlossomLeavesBlock;
import vazkii.quark.content.world.module.AncientWoodModule;
import vazkii.quark.content.world.module.BlossomTreesModule;

@LoadModule(category=ModuleCategory.BUILDING, antiOverlap={"woodworks", "immersive_weathering"})
public class LeafCarpetModule
extends QuarkModule {
    public static List<LeafCarpetBlock> carpets = new LinkedList<LeafCarpetBlock>();

    @Override
    public void register() {
        for (VanillaWoods.Wood wood : VanillaWoods.OVERWORLD) {
            this.carpet(wood.leaf());
        }
        this.carpet(Blocks.f_152470_);
        this.carpet(Blocks.f_152471_);
    }

    @Override
    public void postRegister() {
        BlossomTreesModule.trees.keySet().stream().map(t -> (BlossomLeavesBlock)t.leaf.m_60734_()).forEach(this::blossomCarpet);
        this.carpetBlock(AncientWoodModule.ancient_leaves).setCondition(() -> ModuleLoader.INSTANCE.isModuleEnabled(AncientWoodModule.class));
    }

    @Override
    public void loadComplete() {
        this.enqueue(() -> {
            for (LeafCarpetBlock c : carpets) {
                if (c.m_5456_() == null) continue;
                ComposterBlock.f_51914_.put((Object)c.m_5456_(), 0.2f);
            }
        });
    }

    private void carpet(Block base) {
        this.carpetBlock(base);
    }

    private void blossomCarpet(BlossomLeavesBlock base) {
        this.carpetBlock((Block)base).setCondition(base::isEnabled);
    }

    private LeafCarpetBlock carpetBlock(Block base) {
        LeafCarpetBlock carpet = new LeafCarpetBlock(IQuarkBlock.inherit(base, s -> s.replaceAll("_leaves", "_leaf_carpet")), base, this);
        carpets.add(carpet);
        return carpet;
    }
}

