/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class MixedExclusionRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation res;
    private NonNullList<Ingredient> ingredients;
    private final String type;
    private final ItemStack output;
    private final TagKey<Item> tag;
    private final ItemStack placeholder;

    public MixedExclusionRecipe(ResourceLocation res, String type, ItemStack output, TagKey<Item> tag, ItemStack placeholder) {
        this.res = res;
        this.type = type;
        this.output = output;
        this.tag = tag;
        this.placeholder = placeholder;
    }

    public static MixedExclusionRecipe forChest(String type, ResourceLocation res, boolean log) {
        ItemStack output = new ItemStack((ItemLike)Items.f_42009_, log ? 4 : 1);
        TagKey tag = log ? ItemTags.f_13182_ : ItemTags.f_13168_;
        ItemStack placeholder = new ItemStack((ItemLike)(log ? Items.f_41837_ : Items.f_42647_));
        return new MixedExclusionRecipe(res, type, output, (TagKey<Item>)tag, placeholder);
    }

    public static MixedExclusionRecipe forFurnace(String type, ResourceLocation res) {
        ItemStack output = new ItemStack((ItemLike)Items.f_41962_);
        TagKey tag = ItemTags.f_13166_;
        ItemStack placeholder = new ItemStack((ItemLike)Items.f_42594_);
        return new MixedExclusionRecipe(res, type, output, (TagKey<Item>)tag, placeholder);
    }

    public boolean m_8004_(int x, int y) {
        return x == 3 && y == 3;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer arg0) {
        return this.output.m_41777_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.res;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        if (inv.m_8020_(4).m_41619_()) {
            ItemStack first = null;
            boolean foundDifference = false;
            for (int i = 0; i < 9; ++i) {
                if (i == 4) continue;
                ItemStack stack = inv.m_8020_(i);
                if (!stack.m_41619_() && stack.m_204117_(this.tag)) {
                    if (first == null) {
                        first = stack;
                        continue;
                    }
                    if (ItemStack.m_41746_((ItemStack)first, (ItemStack)stack)) continue;
                    foundDifference = true;
                    continue;
                }
                return false;
            }
            return foundDifference;
        }
        return false;
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        if (this.ingredients == null) {
            NonNullList list = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            Ingredient ingr = Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.placeholder});
            for (int i = 0; i < 8; ++i) {
                list.set(i < 4 ? i : i + 1, (Object)ingr);
            }
            this.ingredients = list;
        }
        return this.ingredients;
    }

    public boolean m_5598_() {
        return true;
    }

    private static class Serializer
    implements RecipeSerializer<MixedExclusionRecipe> {
        private Serializer() {
        }

        @Nonnull
        public MixedExclusionRecipe fromJson(@Nonnull ResourceLocation arg0, JsonObject arg1) {
            String type = arg1.get("subtype").getAsString();
            return this.forType(arg0, type);
        }

        public MixedExclusionRecipe fromNetwork(@Nonnull ResourceLocation arg0, FriendlyByteBuf arg1) {
            return this.forType(arg0, arg1.m_130277_());
        }

        public void toNetwork(FriendlyByteBuf arg0, MixedExclusionRecipe arg1) {
            arg0.m_130070_(arg1.type);
        }

        private MixedExclusionRecipe forType(ResourceLocation res, String type) {
            return switch (type) {
                case "chest" -> MixedExclusionRecipe.forChest(type, res, false);
                case "chest4" -> MixedExclusionRecipe.forChest(type, res, true);
                case "furnace" -> MixedExclusionRecipe.forFurnace(type, res);
                default -> null;
            };
        }
    }
}

