/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.experimental.module.EnchantmentsBegoneModule;
import vazkii.quark.content.tools.module.AncientTomesModule;

public class AncientTomeItem
extends QuarkItem {
    public AncientTomeItem(QuarkModule module) {
        super("ancient_tome", module, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean m_5812_(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public static ItemStack getEnchantedItemStack(Enchantment ench) {
        ItemStack newStack = new ItemStack((ItemLike)AncientTomesModule.ancient_tome);
        EnchantedBookItem.m_41153_((ItemStack)newStack, (EnchantmentInstance)new EnchantmentInstance(ench, ench.m_6586_()));
        return newStack;
    }

    @Override
    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (!(!this.isEnabled() && group != CreativeModeTab.f_40754_ || group != CreativeModeTab.f_40754_ && group.m_40795_().length == 0)) {
            ForgeRegistries.ENCHANTMENTS.forEach(ench -> {
                if (!(EnchantmentsBegoneModule.shouldBegone(ench) || AncientTomesModule.sanityCheck && ench.m_6586_() == 1 || AncientTomesModule.isInitialized() && !AncientTomesModule.validEnchants.contains(ench) || group != CreativeModeTab.f_40754_ && !group.m_40776_(ench.f_44672_))) {
                    items.add((Object)AncientTomeItem.getEnchantedItemStack(ench));
                }
            });
        }
    }

    public static Component getFullTooltipText(Enchantment ench) {
        return Component.m_237110_((String)"quark.misc.ancient_tome_tooltip", (Object[])new Object[]{Component.m_237115_((String)ench.m_44704_()), Component.m_237115_((String)("enchantment.level." + (ench.m_6586_() + 1)))}).m_130940_(ChatFormatting.GRAY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Enchantment ench = AncientTomesModule.getTomeEnchantment(stack);
        if (ench != null) {
            tooltip.add(AncientTomeItem.getFullTooltipText(ench));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"quark.misc.ancient_tome_tooltip_any").m_130940_(ChatFormatting.GRAY));
        }
        if (AncientTomesModule.curseGear) {
            tooltip.add((Component)Component.m_237115_((String)"quark.misc.ancient_tome_tooltip_curse").m_130940_(ChatFormatting.RED));
        }
    }
}

