/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.undergroundstyle.base;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.world.undergroundstyle.base.UndergroundStyleGenerator;

public abstract class UndergroundStyle {
    private static TagKey<Block> fillerTag = null;
    public static final Predicate<BlockState> STONE_TYPES_MATCHER = state -> {
        if (state == null) {
            return false;
        }
        if (fillerTag == null) {
            fillerTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "underground_biome_replaceable"));
        }
        return state.m_204336_(fillerTag);
    };
    public double dungeonChance;

    public final void fill(UndergroundStyleGenerator.Context context, BlockPos pos) {
        WorldGenRegion world = context.world;
        BlockState state = world.m_8055_(pos);
        if (state.m_60800_((BlockGetter)world, pos) == -1.0f) {
            return;
        }
        boolean shrouded = false;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        while (!world.m_151570_((BlockPos)testPos)) {
            if (!world.m_8055_((BlockPos)(testPos = testPos.m_7494_())).m_60804_((BlockGetter)world, (BlockPos)testPos)) continue;
            shrouded = true;
            break;
        }
        if (!shrouded) {
            return;
        }
        if (this.isFloor((LevelAccessor)world, pos, state)) {
            context.floorList.add(pos);
            this.fillFloor(context, pos, state);
        } else if (this.isCeiling((LevelAccessor)world, pos, state)) {
            context.ceilingList.add(pos);
            this.fillCeiling(context, pos, state);
        } else if (this.isWall((LevelAccessor)world, pos, state)) {
            context.wallMap.put(pos, this.getBorderSide((LevelAccessor)world, pos));
            this.fillWall(context, pos, state);
        } else if (this.isInside(state)) {
            context.insideList.add(pos);
            this.fillInside(context, pos, state);
        }
    }

    public abstract void fillFloor(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillCeiling(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillWall(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillInside(UndergroundStyleGenerator.Context var1, BlockPos var2, BlockState var3);

    public void finalFloorPass(UndergroundStyleGenerator.Context context, BlockPos pos) {
    }

    public void finalCeilingPass(UndergroundStyleGenerator.Context context, BlockPos pos) {
    }

    public void finalWallPass(UndergroundStyleGenerator.Context context, BlockPos pos) {
    }

    public void finalInsidePass(UndergroundStyleGenerator.Context context, BlockPos pos) {
    }

    public boolean isFloor(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!state.m_60804_((BlockGetter)world, pos)) {
            return false;
        }
        BlockPos upPos = pos.m_7494_();
        return world.m_46859_(upPos) || world.m_8055_(upPos).m_60767_().m_76336_();
    }

    public boolean isCeiling(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!state.m_60804_((BlockGetter)world, pos)) {
            return false;
        }
        BlockPos downPos = pos.m_7495_();
        return world.m_46859_(downPos) || world.m_8055_(downPos).m_60767_().m_76336_();
    }

    public boolean isWall(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!state.m_60804_((BlockGetter)world, pos) || !STONE_TYPES_MATCHER.test(state)) {
            return false;
        }
        return this.isBorder(world, pos);
    }

    public Direction getBorderSide(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        for (Direction facing : MiscUtil.HORIZONTALS) {
            BlockPos offsetPos = pos.m_121945_(facing);
            BlockState stateAt = world.m_8055_(offsetPos);
            if ((state == stateAt || !world.m_46859_(offsetPos)) && !stateAt.m_60767_().m_76336_()) continue;
            return facing;
        }
        return null;
    }

    public boolean isBorder(LevelAccessor world, BlockPos pos) {
        return this.getBorderSide(world, pos) != null;
    }

    public boolean isInside(BlockState state) {
        return STONE_TYPES_MATCHER.test(state);
    }

    public static Rotation rotationFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }
}

