/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.compat.emi;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.railwayteam.railways.registry.CRPalettes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class EmiRecipeDefaultsGen
implements DataProvider {
    public static final List<ResourceLocation> DEFAULT_RECIPES = new ArrayList<ResourceLocation>();
    public static final Map<TagKey<Item>, ResourceLocation> TAG_DEFAULTS = new LinkedHashMap<TagKey<Item>, ResourceLocation>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator gen;

    public EmiRecipeDefaultsGen(DataGenerator gen) {
        this.gen = gen;
    }

    public void m_213708_(@NotNull CachedOutput output) throws IOException {
        Path path = this.gen.m_123916_().resolve("assets/emi/recipe/defaults/railways.json");
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);
        ((Writer)writer).append(this.run());
        ((Writer)writer).close();
        output.m_213871_(path, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }

    private String run() {
        JsonObject object = new JsonObject();
        JsonArray added = new JsonArray();
        JsonObject tags = new JsonObject();
        DEFAULT_RECIPES.forEach(loc -> added.add(loc.toString()));
        TAG_DEFAULTS.put(CRPalettes.CYCLE_GROUPS.get(null), CRPalettes.Styles.RIVETED.get(null).getId());
        TAG_DEFAULTS.forEach((tag, itemLoc) -> {
            String tagString = "#item:" + tag.f_203868_();
            String itemString = "item:" + itemLoc;
            tags.addProperty(tagString, itemString);
        });
        object.add("added", (JsonElement)added);
        object.add("tags", (JsonElement)tags);
        object.add("resolutions", (JsonElement)new JsonObject());
        object.add("disabled", (JsonElement)new JsonArray());
        return GSON.toJson((JsonElement)object);
    }

    @NotNull
    public String m_6055_() {
        return "Steam 'n' Rails EMI recipe tree defaults";
    }
}

