/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.datafixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.util.datafix.fixes.References;

public class LocoMetalSmokeboxFacingFix
extends DataFix {
    private final String name;

    public LocoMetalSmokeboxFacingFix(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.name = name;
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped(this.name + " for block_state", this.getInputSchema().getType(References.f_16783_), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("Name").asString().result();
            if (optional.isPresent() && ((String)optional.get()).matches("railways:(.*)_locometal_smokebox")) {
                Dynamic axis = dynamic.get("Properties").orElseEmptyMap().get("axis").orElseEmptyMap();
                Dynamic properties = dynamic.get("Properties").orElseEmptyMap();
                String axisString = axis.getValue().toString().replace("\"", "");
                switch (Direction.Axis.valueOf((String)axisString)) {
                    case X: {
                        properties = properties.set("facing", dynamic.createString("east"));
                        break;
                    }
                    case Y: {
                        properties = properties.set("facing", dynamic.createString("up"));
                        break;
                    }
                    case Z: {
                        properties = properties.set("facing", dynamic.createString("north"));
                    }
                }
                dynamic = dynamic.set("Properties", properties);
                return dynamic;
            }
            return dynamic;
        }));
    }
}

