/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;

public class FuelTankRenderer
extends SafeBlockEntityRenderer<FuelTankBlockEntity> {
    public FuelTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(FuelTankBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.window) {
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FuelTankBlockEntity.FuelFluidHandler tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        float xMin = tankHullWidth;
        float xMax = xMin + (float)be.width - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)be.width - 2.0f * tankHullWidth;
        ms.m_85836_();
        ms.m_85837_(0.0, (double)(clampedLevel - totalHeight), 0.0);
        FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
        ms.m_85849_();
    }

    public boolean shouldRenderOffScreen(FuelTankBlockEntity be) {
        return be.isController();
    }
}

