/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.util.DevCapeUtils;
import com.railwayteam.railways.util.Utils;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class MixinPlayerInfo {
    @Shadow
    @Final
    private GameProfile f_105298_;
    @Shadow
    @Final
    private Map<MinecraftProfileTexture.Type, ResourceLocation> f_105299_;
    @Shadow
    @Nullable
    private String f_105303_;
    @Unique
    private boolean railways$texturesLoaded;
    @Unique
    private static final ResourceLocation DEV_CAPE = Railways.asResource("textures/misc/dev_cape.png");

    @Inject(method={"getSkinLocation"}, at={@At(value="HEAD")}, require=0)
    private void registerSkinTextures(CallbackInfoReturnable<ResourceLocation> cir) {
        if (Utils.isDevEnv()) {
            this.f_105299_.put(MinecraftProfileTexture.Type.SKIN, Railways.asResource("textures/misc/devenv_skin.png"));
        }
    }

    @Inject(method={"getCapeLocation"}, at={@At(value="HEAD")})
    private void registerCapeTextures(CallbackInfoReturnable<ResourceLocation> cir) {
        if (!this.railways$texturesLoaded && DevCapeUtils.INSTANCE.useDevCape(this.f_105298_.getId())) {
            this.railways$texturesLoaded = true;
            this.f_105299_.put(MinecraftProfileTexture.Type.CAPE, DEV_CAPE);
        }
    }

    @Inject(method={"getCapeLocation"}, at={@At(value="RETURN")}, cancellable=true)
    private void skipCapeIfNeeded(CallbackInfoReturnable<ResourceLocation> cir) {
        if (Objects.equals(DEV_CAPE, cir.getReturnValue()) && !DevCapeUtils.INSTANCE.useDevCape(this.f_105298_.getId())) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"registerTextures"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/SkinManager;registerSkins(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/resources/SkinManager$SkinTextureCallback;Z)V")}, require=0)
    private void railways$setModelToLarge(CallbackInfo ci) {
        if (Utils.isDevEnv()) {
            this.f_105303_ = "default";
        }
    }
}

