/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CRTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)id);
    }

    public static void register() {
        AllBlockTags.register();
        AllItemTags.register();
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        ResourceLocation loc;
        for (AllBlockTags allBlockTags : AllBlockTags.values()) {
            loc = allBlockTags.tag.f_203868_();
            consumer.accept("tag.block." + loc.m_135827_() + "." + loc.m_135815_().replace('/', '.'), TextUtils.titleCaseConversion(allBlockTags.name()).replace('_', ' '));
        }
        for (Enum enum_ : AllItemTags.values()) {
            loc = ((AllItemTags)enum_).tag.f_203868_();
            consumer.accept("tag.item." + loc.m_135827_() + "." + loc.m_135815_().replace('/', '.'), TextUtils.titleCaseConversion(enum_.name().replace('_', ' ')));
        }
        consumer.accept("tag.item.forge.string", "String");
    }

    public static enum AllBlockTags {
        SEMAPHORE_POLES,
        TRACK_CASING_BLACKLIST(NameSpace.MOD, NameSpace.MOD.optionalDefault, false),
        CONDUCTOR_SPY_USABLE(NameSpace.MOD, NameSpace.MOD.optionalDefault, false),
        LOCOMETAL,
        LOCOMETAL_BOILERS;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CRTags.optionalTag(Registry.f_122824_, id) : TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        public static void register() {
        }
    }

    public static enum AllItemTags {
        CONDUCTOR_CAPS,
        PHANTOM_TRACK_REVEALING,
        DECO_COUPLERS,
        WOODEN_HEADSTOCKS,
        COPYCAT_HEADSTOCKS,
        CABOOSESTYLE_STACK,
        LONG_STACK,
        COALBURNER_STACK,
        OILBURNER_STACK,
        STREAMLINED_STACK,
        WOODBURNER_STACK,
        NOT_TRAIN_FUEL;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CRTags.optionalTag(Registry.f_122827_, id) : TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        public static void register() {
        }
    }

    public static enum NameSpace {
        MOD("railways", false, true),
        FORGE("forge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

