/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FreezerBlock;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.tileentity.FridgeBlockEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public class FridgeBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();
    private final Supplier<RegistryObject<Block>> freezer;

    public FridgeBlock(BlockBehaviour.Properties properties, Supplier<RegistryObject<Block>> freezer) {
        super(properties);
        this.freezer = freezer;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            Direction direction = (Direction)state1.m_61143_((Property)DIRECTION);
            boolean open = (Boolean)state1.m_61143_((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));
            if (open) {
                VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), Direction.SOUTH));
                VoxelShape[] DOOR = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)29.0), Direction.SOUTH));
                shapes.add(BASE[direction.m_122416_()]);
                shapes.add(DOOR[direction.m_122416_()]);
            } else {
                shapes.add(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
            }
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return context == CollisionContext.m_82749_() ? Shapes.m_83144_() : this.getShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_() && !level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof FridgeBlockEntity) {
            FridgeBlockEntity blockEntity2 = (FridgeBlockEntity)blockEntity;
            playerEntity.m_5893_((MenuProvider)blockEntity2);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (belowState.m_60734_() instanceof FreezerBlock) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, pos.m_7495_(), Block.m_49956_((BlockState)belowState));
        }
        super.m_5707_(level, pos, state, player);
    }

    public ItemStack m_7397_(BlockGetter reader, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.freezer.get().get());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }
}

