/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModSounds {
    private static final DeferredRegister<SoundEvent> SOUND_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"plane");
    public static final RegistryObject<SoundEvent> ENGINE_STOP = ModSounds.addSound("engine_stop");
    public static final RegistryObject<SoundEvent> ENGINE_STARTING = ModSounds.addSound("engine_starting");
    public static final RegistryObject<SoundEvent> ENGINE_START = ModSounds.addSound("engine_start");
    public static final RegistryObject<SoundEvent> ENGINE_IDLE = ModSounds.addSound("engine_idle");
    public static final RegistryObject<SoundEvent> ENGINE_HIGH = ModSounds.addSound("engine_high");
    public static final RegistryObject<SoundEvent> CRASH = ModSounds.addSound("crash");
    public static final RegistryObject<SoundEvent> RATCHET = ModSounds.addSound("ratchet");

    public static RegistryObject<SoundEvent> addSound(String soundName) {
        return SOUND_REGISTER.register(soundName, () -> new SoundEvent(new ResourceLocation("plane", soundName)));
    }

    public static void init() {
        SOUND_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume, float pitch) {
        if (entity != null) {
            world.m_5594_(entity, pos, evt, category, volume, pitch);
        } else if (!world.f_46443_) {
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, evt, category, volume, pitch);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(AbstractTickableSoundInstance loop, Level world) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)loop);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoopDelayed(AbstractTickableSoundInstance loop, Level world, int delay) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)loop, delay);
        }
    }
}

