/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.content.client.module.ChestSearchingModule;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;

public class ShulkerBoxTooltips {
    public static final ResourceLocation WIDGET_RESOURCE = new ResourceLocation("quark", "textures/misc/shulker_widget.png");

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (SimilarBlockTypeHandler.isShulkerBox(stack)) {
            CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)false);
            if (cmp.m_128441_("LootTable")) {
                return;
            }
            if (!cmp.m_128441_("id")) {
                return;
            }
            BlockEntity te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), (CompoundTag)cmp);
            if (te != null && te.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                List tooltip = event.getTooltipElements();
                ArrayList tooltipCopy = new ArrayList(tooltip);
                for (int i = 1; i < tooltipCopy.size(); ++i) {
                    String s;
                    Either either = (Either)tooltipCopy.get(i);
                    if (!either.left().isPresent() || (s = ((FormattedText)either.left().get()).getString()).startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                    tooltip.remove(either);
                }
                if (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.m_96638_()) {
                    tooltip.add(1, Either.right((Object)new ShulkerComponent(stack)));
                }
                if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.m_96638_()) {
                    tooltip.add(1, Either.left((Object)Component.m_237115_((String)"quark.misc.shulker_box_shift")));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ShulkerComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {9, 3}, {9, 5}, {9, 6}, {9, 8}, {9, 9}, {12, 9}};
        private static final int CORNER = 5;
        private static final int BUFFER = 1;
        private static final int EDGE = 18;

        public void m_183452_(@Nonnull Font font, int tooltipX, int tooltipY, @Nonnull PoseStack pose, @Nonnull ItemRenderer itemRenderer, int something) {
            Minecraft mc = Minecraft.m_91087_();
            CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)this.stack, (String)"BlockEntityTag", (boolean)true);
            if (cmp != null) {
                BlockEntity te;
                if (cmp.m_128441_("LootTable")) {
                    return;
                }
                if (!cmp.m_128441_("id")) {
                    cmp = cmp.m_6426_();
                    cmp.m_128359_("id", "minecraft:shulker_box");
                }
                if ((te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)this.stack.m_41720_()).m_40614_().m_49966_(), (CompoundTag)cmp)) != null) {
                    if (te instanceof RandomizableContainerBlockEntity) {
                        RandomizableContainerBlockEntity randomizable = (RandomizableContainerBlockEntity)te;
                        randomizable.m_59626_(null, 0L);
                    }
                    LazyOptional handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    handler.ifPresent(capability -> {
                        ShulkerBoxBlock boxBlock;
                        DyeColor dye;
                        Block patt5419$temp;
                        Window window;
                        int texWidth;
                        int right;
                        ItemStack currentBox = this.stack;
                        int currentX = tooltipX;
                        int currentY = tooltipY - 1;
                        int size = capability.getSlots();
                        int[] dims = new int[]{Math.min(size, 9), Math.max(size / 9, 1)};
                        for (int[] testAgainst : TARGET_RATIOS) {
                            if (testAgainst[0] * testAgainst[1] != size) continue;
                            dims = testAgainst;
                            break;
                        }
                        if ((right = currentX + (texWidth = 10 + 18 * dims[0])) > (window = mc.m_91268_()).m_85445_()) {
                            currentX -= right - window.m_85445_();
                        }
                        pose.m_85836_();
                        pose.m_85837_(0.0, 0.0, 700.0);
                        int color = -1;
                        if (ImprovedTooltipsModule.shulkerBoxUseColors && (patt5419$temp = ((BlockItem)currentBox.m_41720_()).m_40614_()) instanceof ShulkerBoxBlock && (dye = (boxBlock = (ShulkerBoxBlock)patt5419$temp).m_56261_()) != null) {
                            float[] colorComponents = dye.m_41068_();
                            color = (int)(colorComponents[0] * 255.0f) << 16 | (int)(colorComponents[1] * 255.0f) << 8 | (int)(colorComponents[2] * 255.0f);
                        }
                        ShulkerComponent.renderTooltipBackground(mc, pose, currentX, currentY, dims[0], dims[1], color);
                        ItemRenderer render = mc.m_91291_();
                        for (int i = 0; i < size; ++i) {
                            ItemStack itemstack = capability.getStackInSlot(i);
                            int xp = currentX + 6 + i % 9 * 18;
                            int yp = currentY + 6 + i / 9 * 18;
                            if (!itemstack.m_41619_()) {
                                render.m_115203_(itemstack, xp, yp);
                                render.m_115169_(mc.f_91062_, itemstack, xp, yp);
                            }
                            if (ChestSearchingModule.namesMatch(itemstack)) continue;
                            RenderSystem.m_69465_();
                            GuiComponent.m_93172_((PoseStack)pose, (int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)-1442840576);
                        }
                        pose.m_85849_();
                    });
                }
            }
        }

        public static void renderTooltipBackground(Minecraft mc, PoseStack matrix, int x, int y, int width, int height, int color) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGET_RESOURCE);
            RenderSystem.m_157429_((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            GuiComponent.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 5 + 18 * width), (int)(y + 5 + 18 * height), (float)25.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 5 + 18 * width), (int)y, (float)25.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)matrix, (int)x, (int)(y + 5 + 18 * height), (float)0.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
            for (int row = 0; row < height; ++row) {
                GuiComponent.m_93133_((PoseStack)matrix, (int)x, (int)(y + 5 + 18 * row), (float)0.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
                GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 5 + 18 * width), (int)(y + 5 + 18 * row), (float)25.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
                for (int col = 0; col < width; ++col) {
                    if (row == 0) {
                        GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 5 + 18 * col), (int)y, (float)6.0f, (float)0.0f, (int)18, (int)5, (int)256, (int)256);
                        GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 5 + 18 * col), (int)(y + 5 + 18 * height), (float)6.0f, (float)25.0f, (int)18, (int)5, (int)256, (int)256);
                    }
                    GuiComponent.m_93133_((PoseStack)matrix, (int)(x + 5 + 18 * col), (int)(y + 5 + 18 * row), (float)6.0f, (float)6.0f, (int)18, (int)18, (int)256, (int)256);
                }
            }
        }

        public int m_142103_() {
            return 65;
        }

        public int m_142069_(@Nonnull Font font) {
            return 171;
        }
    }
}

