/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.content.world.block.MonsterBoxBlock;
import vazkii.quark.content.world.block.be.MonsterBoxBlockEntity;
import vazkii.quark.content.world.gen.MonsterBoxGenerator;
import vazkii.quark.mixin.accessor.AccessorLivingEntity;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class MonsterBoxModule
extends QuarkModule {
    public static final String TAG_MONSTER_BOX_SPAWNED = "quark:monster_box_spawned";
    public static final ResourceLocation MONSTER_BOX_LOOT_TABLE = new ResourceLocation("quark", "misc/monster_box");
    public static final ResourceLocation MONSTER_BOX_SPAWNS_LOOT_TABLE = new ResourceLocation("quark", "misc/monster_box_spawns");
    public static BlockEntityType<MonsterBoxBlockEntity> blockEntityType;
    @Config(description="The chance for the monster box generator to try and place one in a chunk, 1 is 100%\nThis can be higher than 100% if you want multiple per chunk, , 0 is 0%")
    public static double chancePerChunk;
    @Config
    public static int minY;
    @Config
    public static int maxY;
    @Config
    public static int minMobCount;
    @Config
    public static int maxMobCount;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static boolean enableExtraLootTable;
    @Config
    public static double activationRange;
    @Config(description="How many blocks to search vertically from a position before trying to place a block. Higher means you'll get more boxes in open spaces.")
    public static int searchRange;
    public static Block monster_box;

    @Override
    public void register() {
        monster_box = new MonsterBoxBlock(this);
        blockEntityType = BlockEntityType.Builder.m_155273_(MonsterBoxBlockEntity::new, (Block[])new Block[]{monster_box}).m_58966_(null);
        RegistryHelper.register(blockEntityType, (String)"monster_box", (ResourceKey)Registry.f_122907_);
    }

    @Override
    public void setup() {
        WorldGenHandler.addGenerator(this, new MonsterBoxGenerator(dimensions), GenerationStep.Decoration.UNDERGROUND_DECORATION, 6);
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        if (enableExtraLootTable && (level = entity.m_20193_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.getPersistentData().m_128471_(TAG_MONSTER_BOX_SPAWNED) && entity.f_19853_.m_46469_().m_46207_(GameRules.f_46135_) && ((AccessorLivingEntity)entity).quark$lastHurtByPlayerTime() > 0) {
                LootTable loot = serverLevel.m_7654_().m_129898_().m_79217_(MONSTER_BOX_LOOT_TABLE);
                ObjectArrayList generatedLoot = loot.m_230922_(((AccessorLivingEntity)entity).quark$createLootContext(true, event.getSource()).m_78975_(LootContextParamSets.f_81415_));
                entity.captureDrops(new ArrayList());
                for (ItemStack stack : generatedLoot) {
                    entity.m_19983_(stack);
                }
                event.getDrops().addAll(entity.captureDrops(null));
            }
        }
    }

    static {
        chancePerChunk = 0.2;
        minY = -50;
        maxY = 0;
        minMobCount = 5;
        maxMobCount = 8;
        dimensions = DimensionConfig.overworld(false);
        enableExtraLootTable = true;
        activationRange = 2.5;
        searchRange = 15;
        monster_box = null;
    }
}

