/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.mojang.math.Vector3f;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.OpenLaserScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.PacketDistributor;

public class LaserBlock
extends DisguisableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public LaserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_) {
            Player player;
            this.setLaser(level, pos, entity instanceof Player ? (player = (Player)entity) : null);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LaserBlockBlockEntity be = (LaserBlockBlockEntity)level.m_7702_(pos);
        if (be.isOwnedBy(player)) {
            if (!level.f_46443_) {
                if (!be.isEnabled()) {
                    player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenLaserScreen(pos, be.getSideConfig()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setLaser(Level level, BlockPos pos, Player player) {
        for (Direction facing : Direction.values()) {
            this.setLaser(level, pos, facing, player);
        }
    }

    public void setLaser(Level level, BlockPos pos, Direction facing, Player player) {
        LaserBlockBlockEntity thisBe = (LaserBlockBlockEntity)level.m_7702_(pos);
        if (!thisBe.isSideEnabled(facing)) {
            return;
        }
        int boundType = facing == Direction.UP || facing == Direction.DOWN ? 1 : (facing == Direction.NORTH || facing == Direction.SOUTH ? 2 : 3);
        for (int i = 1; i <= (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
            BlockPos offsetPos = pos.m_5484_(facing, i);
            BlockState offsetState = level.m_8055_(offsetPos);
            Block offsetBlock = offsetState.m_60734_();
            if (!offsetState.m_60795_() && !offsetState.m_60767_().m_76336_() && offsetBlock != SCContent.LASER_BLOCK.get()) {
                return;
            }
            if (offsetBlock != SCContent.LASER_BLOCK.get()) continue;
            LaserBlockBlockEntity thatBe = (LaserBlockBlockEntity)level.m_7702_(offsetPos);
            if (thisBe.getOwner().owns(thatBe) && thisBe.isEnabled() && thatBe.isEnabled()) {
                if (!thatBe.isSideEnabled(facing.m_122424_())) {
                    thisBe.setSideEnabled(facing, false, null);
                    return;
                }
                ModuleType failedType = thisBe.synchronizeWith(thatBe);
                if (failedType != null) {
                    if (player != null) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:laser.sync_failed", Utils.getFormattedCoordinates(thatBe.m_58899_()), Utils.localize(failedType.getTranslationKey(), new Object[0])), ChatFormatting.RED);
                        thisBe.setSideEnabled(facing, false, null);
                        thatBe.setSideEnabled(facing.m_122424_(), false, null);
                        player.m_6915_();
                    }
                    return;
                }
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.m_5484_(facing, j);
                    offsetState = level.m_8055_(offsetPos);
                    if (!offsetState.m_60795_() && !offsetState.m_60767_().m_76336_()) continue;
                    level.m_46597_(offsetPos, (BlockState)((Block)SCContent.LASER_FIELD.get()).m_49966_().m_61124_((Property)LaserFieldBlock.BOUNDTYPE, (Comparable)Integer.valueOf(boundType)));
                    BlockEntity blockEntity = level.m_7702_(offsetPos);
                    if (!(blockEntity instanceof IOwnable)) continue;
                    IOwnable ownable = (IOwnable)blockEntity;
                    ownable.setOwner(thisBe.getOwner().getUUID(), thisBe.getOwner().getName());
                }
            }
            return;
        }
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            LaserBlock.destroyAdjacentLasers(level, pos);
        }
    }

    public static void destroyAdjacentLasers(LevelAccessor level, BlockPos pos) {
        BlockUtils.removeInSequence((direction, state) -> {
            if (state.m_60734_() != SCContent.LASER_FIELD.get()) {
                return false;
            }
            int boundType = direction == Direction.UP || direction == Direction.DOWN ? 1 : (direction == Direction.NORTH || direction == Direction.SOUTH ? 2 : 3);
            return (Integer)state.m_61143_((Property)LaserFieldBlock.BOUNDTYPE) == boundType;
        }, level, pos, Direction.values());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.setLaser(level, pos, null);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return false;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        LaserBlockBlockEntity be;
        BlockEntity blockEntity;
        return (Boolean)state.m_61143_((Property)POWERED) != false && (blockEntity = level.m_7702_(pos)) instanceof LaserBlockBlockEntity && (be = (LaserBlockBlockEntity)blockEntity).isModuleEnabled(ModuleType.REDSTONE) ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.m_6378_(state, level, pos, side);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)SCContent.LASER_BLOCK.get());
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.m_123341_() + 0.5f) + (double)(rand.m_188501_() - 0.5f) * 0.2;
            double y = (double)((float)pos.m_123342_() + 0.7f) + (double)(rand.m_188501_() - 0.5f) * 0.2;
            double z = (double)((float)pos.m_123343_() + 0.5f) + (double)(rand.m_188501_() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float r = 1.0f;
            float g = Math.max(0.0f, 0.19999999f);
            float b = Math.max(0.0f, -0.099999964f);
            Vector3f vec = new Vector3f(r, g, b);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LaserBlockBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }
}

