/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.google.common.base.Function;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.apache.commons.lang3.StringUtils;

public class ColorChooser
extends Screen
implements GuiEventListener,
NarratableEntry {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/color_chooser.png");
    public boolean disabled = true;
    private final int xStart;
    private final int yStart;
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private final Component rText = Component.m_237113_((String)"R");
    private final Component gText = Component.m_237113_((String)"G");
    private final Component bText = Component.m_237113_((String)"B");
    private final Component rgbHexText = Component.m_237113_((String)"#");
    private boolean clickedInDragRegion = false;
    private float h;
    private float s;
    private float b;
    private int colorFieldTop;
    private int colorFieldBottom;
    private int colorFieldLeft;
    private int colorFieldRight;
    private final int colorFieldSize = 75;
    private final HoverChecker colorFieldHoverChecker;
    private float selectionX;
    private float selectionY;
    private final int rgbColor;
    public FixedEditBox rBox;
    public FixedEditBox gBox;
    public FixedEditBox bBox;
    public FixedEditBox rgbHexBox;
    private HueSlider hueSlider;

    public ColorChooser(Component title, int xStart, int yStart, int rgbColor) {
        super(title);
        this.xStart = xStart;
        this.yStart = yStart;
        this.colorFieldLeft = xStart + 6;
        this.colorFieldTop = yStart + 6;
        this.colorFieldRight = this.colorFieldLeft + 75;
        this.colorFieldBottom = this.colorFieldTop + 75;
        this.rgbColor = rgbColor;
        this.colorFieldHoverChecker = new HoverChecker(this.colorFieldTop, this.colorFieldBottom, this.colorFieldLeft, this.colorFieldRight);
    }

    protected void m_7856_() {
        Predicate<String> boxFilter = string -> string.isEmpty() || StringUtils.isNumeric((CharSequence)string);
        Function boxResponder = box -> string -> {
            if (!string.isEmpty()) {
                int number = Integer.parseInt(string);
                Function parsingFunction = editBox -> {
                    if (editBox.m_94155_().isEmpty()) {
                        return 0;
                    }
                    return Integer.parseInt(editBox.m_94155_());
                };
                if (number < 0) {
                    box.m_94144_("0");
                } else if (number > 255) {
                    box.m_94144_("255");
                }
                this.updateHSBValues((Integer)parsingFunction.apply((Object)this.rBox), (Integer)parsingFunction.apply((Object)this.gBox), (Integer)parsingFunction.apply((Object)this.bBox));
                this.updateTextFields((EditBox)box);
                this.onColorChange();
            }
        };
        int red = this.rgbColor >> 16 & 0xFF;
        int green = this.rgbColor >> 8 & 0xFF;
        int blue = this.rgbColor & 0xFF;
        this.updateHSBValues(red, green, blue);
        this.extraAreas.add(new Rect2i(this.xStart, this.yStart, 144, 108));
        this.hueSlider = new HueSlider(this.colorFieldLeft - 2, this.yStart + 85, 82, 20, (double)this.h * 360.0){

            protected void m_5697_() {
                ColorChooser.this.h = (float)this.getValueInt() / 360.0f;
                ColorChooser.this.updateTextFields(null);
                ColorChooser.this.onColorChange();
            }
        };
        this.m_142416_((GuiEventListener)this.hueSlider);
        this.rBox = new FixedEditBox(this.f_96547_, this.colorFieldRight + 13, this.colorFieldTop, 26, 10, this.rText);
        this.m_142416_((GuiEventListener)this.rBox);
        this.gBox = new FixedEditBox(this.f_96547_, this.colorFieldRight + 13, this.colorFieldTop + 15, 26, 10, this.gText);
        this.m_142416_((GuiEventListener)this.gBox);
        this.bBox = new FixedEditBox(this.f_96547_, this.colorFieldRight + 13, this.colorFieldTop + 30, 26, 10, this.bText);
        this.m_142416_((GuiEventListener)this.bBox);
        this.rgbHexBox = new FixedEditBox(this.f_96547_, this.colorFieldRight + 13, this.colorFieldTop + 45, 46, 10, this.rgbHexText);
        this.m_142416_((GuiEventListener)this.rgbHexBox);
        this.rBox.m_94144_("" + red);
        this.gBox.m_94144_("" + green);
        this.bBox.m_94144_("" + blue);
        this.rgbHexBox.m_94144_(Integer.toHexString(this.rgbColor).substring(2));
        this.rBox.m_94199_(3);
        this.gBox.m_94199_(3);
        this.bBox.m_94199_(3);
        this.rgbHexBox.m_94199_(6);
        this.rBox.m_94153_(boxFilter);
        this.gBox.m_94153_(boxFilter);
        this.bBox.m_94153_(boxFilter);
        this.rgbHexBox.m_94153_(string -> string.matches("[0-9a-fA-F]*"));
        this.rBox.m_94151_((Consumer)boxResponder.apply((Object)this.rBox));
        this.gBox.m_94151_((Consumer)boxResponder.apply((Object)this.gBox));
        this.bBox.m_94151_((Consumer)boxResponder.apply((Object)this.bBox));
        this.rgbHexBox.m_94151_(string -> {
            if (!string.isEmpty()) {
                int hexColor = Integer.parseInt(string, 16);
                this.updateHSBValues(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF);
                this.updateTextFields(this.rgbHexBox);
                this.onColorChange();
            }
        });
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        if (!this.disabled) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(pose, this.xStart, this.yStart, 0, 0, 145, 109);
            ClientUtils.fillHorizontalGradient(pose, 0, this.colorFieldLeft, this.colorFieldTop, this.colorFieldRight + 1, this.colorFieldBottom + 1, -1, ClientUtils.HSBtoRGB(this.h, 1.0f, 1.0f));
            ColorChooser.m_168740_((PoseStack)pose, (int)this.colorFieldLeft, (int)this.colorFieldTop, (int)(this.colorFieldRight + 1), (int)(this.colorFieldBottom + 1), (int)0, (int)-16777216, (int)this.m_93252_());
            this.m_93228_(pose, (int)this.selectionX - 1, (int)this.selectionY - 1, this.colorFieldHoverChecker.checkHover(mouseX, mouseY) ? 148 : 145, 20, 3, 3);
            super.m_6305_(pose, mouseX, mouseY, partialTick);
            this.f_96547_.m_92889_(pose, this.rText, (float)(this.colorFieldRight + 5), (float)(this.colorFieldTop + 1), 0x404040);
            this.f_96547_.m_92889_(pose, this.gText, (float)(this.colorFieldRight + 5), (float)(this.colorFieldTop + 16), 0x404040);
            this.f_96547_.m_92889_(pose, this.bText, (float)(this.colorFieldRight + 5), (float)(this.colorFieldTop + 31), 0x404040);
            this.f_96547_.m_92889_(pose, this.rgbHexText, (float)(this.colorFieldRight + 5), (float)(this.colorFieldTop + 46), 0x404040);
        }
    }

    public void m_86600_() {
        if (!this.disabled) {
            this.validateNotEmpty(this.rBox);
            this.validateNotEmpty(this.gBox);
            this.validateNotEmpty(this.bBox);
            if (this.rgbHexBox != null && !this.rgbHexBox.m_93696_() && this.rgbHexBox.m_94155_().isEmpty()) {
                this.rgbHexBox.m_94144_("000000");
            }
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.disabled) {
            super.m_7979_(mouseX, mouseY, button, dragX, dragY);
            if (button == 0 && this.clickedInDragRegion) {
                this.setSelection(mouseX, mouseY);
                return true;
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.disabled) {
            super.m_6375_(mouseX, mouseY, button);
            this.clickedInDragRegion = this.colorFieldHoverChecker.checkHover(mouseX, mouseY);
            if (this.clickedInDragRegion) {
                this.setSelection(mouseX, mouseY);
            }
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.disabled) {
            super.m_6348_(mouseX, mouseY, button);
            this.clickedInDragRegion = false;
        }
        return false;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.disabled ? List.of() : this.extraAreas;
    }

    public int getRGBColor() {
        return ClientUtils.HSBtoRGB(this.h, this.s, this.b);
    }

    private void setSelection(double mouseX, double mouseY) {
        this.selectionX = (int)Mth.m_14008_((double)mouseX, (double)this.colorFieldLeft, (double)this.colorFieldRight);
        this.selectionY = (int)Mth.m_14008_((double)mouseY, (double)this.colorFieldTop, (double)this.colorFieldBottom);
        this.s = (this.selectionX - (float)this.colorFieldLeft) / 75.0f;
        this.b = 1.0f - (this.selectionY - (float)this.colorFieldTop) / 75.0f;
        this.updateTextFields(null);
        this.onColorChange();
    }

    private void updateHSBValues(int red, int green, int blue) {
        float[] hsbColor = ClientUtils.RGBtoHSB(red, green, blue);
        this.h = hsbColor[0];
        this.s = hsbColor[1];
        this.b = hsbColor[2];
        this.updateSelection();
    }

    private void updateTextFields(EditBox excluded) {
        int rgbColor = this.getRGBColor();
        int red = rgbColor >> 16 & 0xFF;
        int green = rgbColor >> 8 & 0xFF;
        int blue = rgbColor & 0xFF;
        this.trySetText(excluded, this.rBox, "" + red);
        this.trySetText(excluded, this.gBox, "" + green);
        this.trySetText(excluded, this.bBox, "" + blue);
        this.trySetText(excluded, this.rgbHexBox, Integer.toHexString(rgbColor).substring(2));
    }

    private void trySetText(EditBox excluded, FixedEditBox editBox, String value) {
        if (excluded != editBox) {
            editBox.f_94093_ = value;
            editBox.updateCursor();
        }
    }

    private void updateSelection() {
        this.selectionX = this.s * 75.0f + (float)this.colorFieldLeft;
        this.selectionY = -this.b * 75.0f + 75.0f + (float)this.colorFieldTop;
        if (this.hueSlider != null) {
            this.hueSlider.m_93611_((double)this.h * 360.0);
        }
    }

    public void onColorChange() {
    }

    private void validateNotEmpty(EditBox box) {
        if (box != null && !box.m_93696_() && box.m_94155_().isEmpty()) {
            box.m_94144_("0");
        }
    }

    class HueSlider
    extends ForgeSlider {
        public HueSlider(int x, int y, int width, int height, double currentValue) {
            super(x, y, width, height, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 360.0, currentValue, 1.0, 0, false);
        }

        protected void m_7906_(PoseStack pose, Minecraft minecraft, int mouseX, int mouseY) {
        }

        public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(pose, this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.f_93621_, this.m_198029_() ? 151 : 145, 0, 6, this.f_93619_);
        }
    }

    public class FixedEditBox
    extends EditBox {
        public FixedEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
        }

        public void m_93692_(boolean focused) {
            if (focused) {
                ColorChooser.this.rBox.m_93692_(false);
                ColorChooser.this.gBox.m_93692_(false);
                ColorChooser.this.bBox.m_93692_(false);
                ColorChooser.this.rgbHexBox.m_93692_(false);
            }
            super.m_93692_(focused);
        }

        public void updateCursor() {
            this.m_94196_(this.f_94093_.length());
            this.m_94208_(this.m_94207_());
        }
    }
}

