/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.Config;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigCondition
implements ICondition {
    public static final ResourceLocation NAME = new ResourceLocation("createdeco", "config");
    private final String configName;
    public static final RecipeSerializer<Recipe<?>> SERIALZIER = null;

    public ConfigCondition(String name) {
        this.configName = name;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return Config.getSetting(this.configName);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ConfigCondition value) {
            json.addProperty("config", value.configName);
        }

        public ConfigCondition read(JsonObject json) {
            return new ConfigCondition(json.get("config").getAsString());
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

