/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.accumulator;

import com.mrh0.createaddition.blocks.accumulator.AccumulatorBlock;
import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricBlockEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class AccumulatorBlockEntity
extends BaseElectricBlockEntity
implements IWireNode,
IHaveGoggleInformation,
IComparatorOverride,
IObserveTileEntity {
    private final Set<LocalNode> wireCache = new HashSet<LocalNode>();
    private final LocalNode[] localNodes;
    private final IWireNode[] nodeCache;
    private boolean wasContraption = false;
    private boolean firstTick = true;
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, 0.5625, -0.3125);
    public static Vec3 OFFSET_WEST = new Vec3(-0.3125, 0.5625, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, 0.5625, 0.3125);
    public static Vec3 OFFSET_EAST = new Vec3(0.3125, 0.5625, 0.0);
    public static final int NODE_COUNT = 8;
    private int lastComparator = 0;
    int lastEnergy = 0;
    private boolean firstTickState = true;
    private int demandOut = 0;
    private int demandIn = 0;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public AccumulatorBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.setLazyTickRate(20);
        this.localNodes = new LocalNode[this.getNodeCount()];
        this.nodeCache = new IWireNode[this.getNodeCount()];
    }

    @Override
    public int getCapacity() {
        return (Integer)Config.ACCUMULATOR_CAPACITY.get();
    }

    @Override
    public int getMaxIn() {
        return (Integer)Config.ACCUMULATOR_MAX_INPUT.get();
    }

    @Override
    public int getMaxOut() {
        return (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get();
    }

    @Override
    @Nullable
    public IWireNode getWireNode(int index) {
        return IWireNode.getWireNodeFrom(index, this, this.localNodes, this.nodeCache, this.f_58857_);
    }

    @Override
    @Nullable
    public LocalNode getLocalNode(int index) {
        return this.localNodes[index];
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        if (node > 3) {
            switch ((Direction)this.m_58900_().m_61143_((Property)AccumulatorBlock.FACING)) {
                case NORTH: {
                    return OFFSET_NORTH;
                }
                case WEST: {
                    return OFFSET_WEST;
                }
                case SOUTH: {
                    return OFFSET_SOUTH;
                }
                case EAST: {
                    return OFFSET_EAST;
                }
            }
        } else {
            switch ((Direction)this.m_58900_().m_61143_((Property)AccumulatorBlock.FACING)) {
                case NORTH: {
                    return OFFSET_SOUTH;
                }
                case WEST: {
                    return OFFSET_EAST;
                }
                case SOUTH: {
                    return OFFSET_NORTH;
                }
                case EAST: {
                    return OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != Direction.UP;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getAvailableNode(Vec3 pos) {
        Direction dir = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)AccumulatorBlock.FACING);
        boolean upper = true;
        pos = pos.m_82492_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        switch (dir) {
            case NORTH: {
                upper = pos.m_7094_() < 0.5;
                break;
            }
            case WEST: {
                upper = pos.m_7096_() < 0.5;
                break;
            }
            case SOUTH: {
                upper = pos.m_7094_() > 0.5;
                break;
            }
            case EAST: {
                upper = pos.m_7096_() > 0.5;
                break;
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setNode(int index, int other, BlockPos pos, WireType type) {
        this.localNodes[index] = new LocalNode((BlockEntity)this, index, other, type, pos);
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public void removeNode(int index, boolean dropWire) {
        LocalNode old = this.localNodes[index];
        this.localNodes[index] = null;
        this.nodeCache[index] = null;
        this.invalidateNodeCache();
        this.notifyUpdate();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        if (dropWire && old != null) {
            this.wireCache.add(old);
        }
    }

    @Override
    public BlockPos getPos() {
        return this.m_58899_();
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (!clientPacket && nbt.m_128441_("node0")) {
            this.convertOldNbt(nbt);
            this.m_6596_();
        }
        this.invalidateLocalNodes();
        this.invalidateNodeCache();
        ListTag nodes = nbt.m_128437_("nodes", 10);
        nodes.forEach(tag -> {
            LocalNode localNode;
            this.localNodes[localNode.getIndex()] = localNode = new LocalNode((BlockEntity)this, (CompoundTag)tag);
        });
        if (nbt.m_128441_("contraption") && !clientPacket) {
            this.wasContraption = nbt.m_128471_("contraption");
            NodeRotation rotation = (NodeRotation)((Object)this.m_58900_().m_61143_(NodeRotation.ROTATION));
            if (rotation != NodeRotation.NONE) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)), 0);
            }
            for (LocalNode localNode : this.localNodes) {
                if (localNode == null) continue;
                localNode.updateRelative(rotation);
            }
        }
        if (!nodes.isEmpty() && this.networkIn != null && this.networkOut != null) {
            this.networkIn.invalidate();
            this.networkOut.invalidate();
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        ListTag nodes = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode localNode = this.localNodes[i];
            if (localNode == null) continue;
            CompoundTag tag = new CompoundTag();
            localNode.write(tag);
            nodes.add((Object)tag);
        }
        nbt.m_128365_("nodes", (Tag)nodes);
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    public void invalidateLocalNodes() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.localNodes[i] = null;
        }
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        int comp = this.getComparetorOverride();
        if (comp != this.lastComparator) {
            this.f_58857_.m_46672_(this.f_58858_, (Block)CABlocks.ACCUMULATOR.get());
        }
        this.lastComparator = comp;
    }

    private void validateNodes() {
        boolean changed = this.validateLocalNodes(this.localNodes);
        this.notifyUpdate();
        if (changed) {
            this.invalidateNodeCache();
            if (this.networkIn != null) {
                this.networkIn.invalidate();
            }
            if (this.networkOut != null) {
                this.networkOut.invalidate();
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            if (this.wasContraption && !this.f_58857_.m_5776_()) {
                this.wasContraption = false;
                this.validateNodes();
            }
        }
        if (!this.wireCache.isEmpty() && !this.m_58901_()) {
            this.handleWireCache(this.f_58857_, this.wireCache);
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        if (this.awakeNetwork(this.f_58857_)) {
            this.notifyUpdate();
        }
        if (this.networkOut == null) {
            return;
        }
        this.localEnergy.extractEnergy(this.networkOut.push(this.localEnergy.extractEnergy(this.demandOut, true)), false);
        this.demandOut = this.networkOut.getDemand();
        this.localEnergy.receiveEnergy(this.networkIn.pull(Math.min(this.demandIn, this.localEnergy.receiveEnergy(this.getMaxIn(), true))), false);
        this.demandIn = this.networkIn.demand(this.localEnergy.receiveEnergy(this.getMaxIn(), true));
    }

    @Override
    public void remove() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            LocalNode localNode = this.getLocalNode(i);
            if (localNode == null || (otherNode = this.getWireNode(i)) == null) continue;
            int ourNode = localNode.getOtherIndex();
            if (localNode.isInvalid()) {
                otherNode.removeNode(ourNode);
                continue;
            }
            otherNode.removeNode(ourNode, true);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndeciesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void setEnergy(int energy) {
        this.localEnergy.setEnergy(energy);
    }

    @Override
    public int getComparetorOverride() {
        return (int)((double)this.localEnergy.getEnergyStored() / (double)this.localEnergy.getMaxEnergyStored() * 15.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray == null) {
            return false;
        }
        int node = this.getAvailableNode(ray.m_82450_());
        ObservePacket.send(this.f_58858_, node);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.accumulator.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.stored").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Util.getTextComponent((IEnergyStorage)this.localEnergy)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.selected").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)(this.isNodeInput(node) ? "createaddition.tooltip.energy.push" : "createaddition.tooltip.energy.pull")).m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_130946_(" ").m_130946_(Util.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(pack.getNode()).getPulled(), this.getNetwork(pack.getNode()).getPushed(), player);
        }
        this.notifyUpdate();
    }

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.Small;
    }

    @Override
    public int getMaxWireLength() {
        return (Integer)Config.SMALL_CONNECTOR_MAX_LENGTH.get();
    }
}

