/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.vertex.transformers;

import me.jellysquid.mods.sodium.client.model.vertex.VertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.glyph.GlyphVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.particle.ParticleVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.model.vertex.transformers.AbstractVertexTransformer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class SpriteTexturedVertexTransformer<T extends VertexSink>
extends AbstractVertexTransformer<T> {
    private final float uMin;
    private final float vMin;
    private final float uMaxMin;
    private final float vMaxMin;

    public SpriteTexturedVertexTransformer(T delegate, TextureAtlasSprite sprite) {
        super(delegate);
        this.uMin = sprite.m_118409_();
        this.vMin = sprite.m_118411_();
        this.uMaxMin = sprite.m_118410_() - this.uMin;
        this.vMaxMin = sprite.m_118412_() - this.vMin;
    }

    protected float transformTextureU(float u) {
        return this.uMaxMin * u + this.uMin;
    }

    protected float transformTextureV(float v) {
        return this.vMaxMin * v + this.vMin;
    }

    public static class Glyph
    extends SpriteTexturedVertexTransformer<GlyphVertexSink>
    implements GlyphVertexSink {
        public Glyph(GlyphVertexSink delegate, TextureAtlasSprite sprite) {
            super(delegate, sprite);
        }

        @Override
        public void writeGlyph(float x, float y, float z, int color, float u, float v, int light) {
            u = this.transformTextureU(u);
            v = this.transformTextureV(v);
            ((GlyphVertexSink)this.delegate).writeGlyph(x, y, z, color, u, v, light);
        }
    }

    public static class Particle
    extends SpriteTexturedVertexTransformer<ParticleVertexSink>
    implements ParticleVertexSink {
        public Particle(ParticleVertexSink delegate, TextureAtlasSprite sprite) {
            super(delegate, sprite);
        }

        @Override
        public void writeParticle(float x, float y, float z, float u, float v, int color, int light) {
            u = this.transformTextureU(u);
            v = this.transformTextureV(v);
            ((ParticleVertexSink)this.delegate).writeParticle(x, y, z, u, v, color, light);
        }
    }

    public static class Quad
    extends SpriteTexturedVertexTransformer<QuadVertexSink>
    implements QuadVertexSink {
        public Quad(QuadVertexSink delegate, TextureAtlasSprite sprite) {
            super(delegate, sprite);
        }

        @Override
        public void writeQuad(float x, float y, float z, int color, float u, float v, int light, int overlay, int normal) {
            u = this.transformTextureU(u);
            v = this.transformTextureV(v);
            ((QuadVertexSink)this.delegate).writeQuad(x, y, z, color, u, v, light, overlay, normal);
        }
    }
}

