/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.jei;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.integration.jei.RecipeResolver;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class JEIComputerCraft
implements IModPlugin {
    private static final IIngredientSubtypeInterpreter<ItemStack> turtleSubtype = (stack, ctx) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof ITurtleItem)) {
            return "";
        }
        ITurtleItem turtle = (ITurtleItem)item;
        StringBuilder name = new StringBuilder("turtle:");
        ITurtleUpgrade left = turtle.getUpgrade((ItemStack)stack, TurtleSide.LEFT);
        ITurtleUpgrade right = turtle.getUpgrade((ItemStack)stack, TurtleSide.RIGHT);
        if (left != null) {
            name.append(left.getUpgradeID());
        }
        if (left != null && right != null) {
            name.append('|');
        }
        if (right != null) {
            name.append(right.getUpgradeID());
        }
        return name.toString();
    };
    private static final IIngredientSubtypeInterpreter<ItemStack> pocketSubtype = (stack, ctx) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemPocketComputer)) {
            return "";
        }
        StringBuilder name = new StringBuilder("pocket:");
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            name.append(upgrade.getUpgradeID());
        }
        return name.toString();
    };
    private static final IIngredientSubtypeInterpreter<ItemStack> diskSubtype = (stack, ctx) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemDisk)) {
            return "";
        }
        ItemDisk disk = (ItemDisk)item;
        int colour = disk.getColour((ItemStack)stack);
        return colour == -1 ? "" : String.format("%06x", colour);
    };

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("computercraft", "jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Registry.ModItems.TURTLE_NORMAL.get()), turtleSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Registry.ModItems.TURTLE_ADVANCED.get()), turtleSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Registry.ModItems.POCKET_COMPUTER_NORMAL.get()), pocketSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get()), pocketSubtype);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)Registry.ModItems.DISK.get()), diskSubtype);
    }

    public void registerAdvanced(IAdvancedRegistration registry) {
        registry.addRecipeManagerPlugin((IRecipeManagerPlugin)new RecipeResolver());
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        IRecipeManager registry = runtime.getRecipeManager();
        List<ItemStack> upgradeItems = RecipeModHelpers.getExtraStacks();
        if (!upgradeItems.isEmpty()) {
            runtime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, upgradeItems);
        }
        IRecipeLookup category = registry.createRecipeLookup(RecipeTypes.CRAFTING);
        category.get().forEach(wrapper -> {
            if (RecipeModHelpers.shouldRemoveRecipe(wrapper.m_6423_())) {
                registry.hideRecipes(RecipeTypes.CRAFTING, Collections.singleton(wrapper));
            }
        });
    }
}

