/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.IECodecs;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public record FractalOptions(Vec3 direction, double scale, int maxAge, int points, float[] colourOut, float[] colourIn) implements ParticleOptions
{
    public static Codec<FractalOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IECodecs.VECTOR3D.fieldOf("direction").forGetter(d -> d.direction), (App)Codec.DOUBLE.fieldOf("scale").forGetter(d -> d.scale), (App)Codec.INT.fieldOf("maxAge").forGetter(d -> d.maxAge), (App)Codec.INT.fieldOf("points").forGetter(d -> d.points), (App)IECodecs.COLOR4.fieldOf("outerColor").forGetter(d -> d.colourOut), (App)IECodecs.COLOR4.fieldOf("innerColor").forGetter(d -> d.colourIn)).apply((Applicative)instance, FractalOptions::new));

    public ParticleType<?> m_6012_() {
        return (ParticleType)IEParticles.FRACTAL.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        int i;
        buffer.writeDouble(this.direction.f_82479_).writeDouble(this.direction.f_82480_).writeDouble(this.direction.f_82481_);
        buffer.writeDouble(this.scale);
        buffer.writeInt(this.maxAge).writeInt(this.points);
        for (i = 0; i < 4; ++i) {
            buffer.writeFloat(this.colourOut[i]);
        }
        for (i = 0; i < 4; ++i) {
            buffer.writeFloat(this.colourIn[i]);
        }
    }

    public String m_5942_() {
        int i;
        String ret = this.direction.f_82479_ + " " + this.direction.f_82480_ + " " + this.direction.f_82481_ + " " + this.scale + " " + this.maxAge + " " + this.points;
        for (i = 0; i < 4; ++i) {
            ret = ret + " " + this.colourOut[i];
        }
        for (i = 0; i < 4; ++i) {
            ret = ret + " " + this.colourIn[i];
        }
        return ret;
    }

    public static class DataDeserializer
    implements ParticleOptions.Deserializer<FractalOptions> {
        public FractalOptions fromCommand(ParticleType<FractalOptions> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            int i;
            double dX = reader.readDouble();
            reader.expect(' ');
            double dY = reader.readDouble();
            reader.expect(' ');
            double dZ = reader.readDouble();
            reader.expect(' ');
            double scale = reader.readDouble();
            reader.expect(' ');
            int maxAge = reader.readInt();
            reader.expect(' ');
            int points = reader.readInt();
            reader.expect(' ');
            float[] colourOut = new float[4];
            float[] colourIn = new float[4];
            for (i = 0; i < 4; ++i) {
                colourOut[i] = reader.readFloat();
                reader.expect(' ');
            }
            for (i = 0; i < 4; ++i) {
                colourIn[i] = reader.readFloat();
                reader.expect(' ');
            }
            return new FractalOptions(new Vec3(dX, dY, dZ), scale, maxAge, points, colourOut, colourIn);
        }

        public FractalOptions fromNetwork(ParticleType<FractalOptions> particleTypeIn, FriendlyByteBuf buffer) {
            int i;
            Vec3 dir = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            double scale = buffer.readDouble();
            int maxAge = buffer.readInt();
            int points = buffer.readInt();
            float[] colourOut = new float[4];
            float[] colourIn = new float[4];
            for (i = 0; i < 4; ++i) {
                colourOut[i] = buffer.readFloat();
            }
            for (i = 0; i < 4; ++i) {
                colourIn[i] = buffer.readFloat();
            }
            return new FractalOptions(dir, scale, maxAge, points, colourOut, colourIn);
        }
    }
}

