/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;

public class ConveyorBlock
extends IEEntityBlock<ConveyorBeltBlockEntity<?>>
implements ConveyorHandler.IConveyorBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60955_();
    public static final String DEFAULT_COVER = "defaultCover";
    private final IConveyorType<?> type;
    public static final EnumProperty<Direction> FACING = IEProperties.FACING_HORIZONTAL;

    public ConveyorBlock(IConveyorType<?> type, BlockBehaviour.Properties props) {
        super((BlockPos pos, BlockState state) -> new ConveyorBeltBlockEntity(type, (BlockPos)pos, (BlockState)state), props);
        this.type = type;
        this.lightOpacity = 0;
    }

    @Override
    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_49811_(group, items);
        if (this.type.acceptsCovers()) {
            items.add((Object)ConveyorBlock.makeCovered((ItemLike)this, IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD).get()));
        }
    }

    public static ItemStack makeCovered(ItemLike conveyor, Block cover) {
        ItemStack covered = new ItemStack(conveyor, 1);
        covered.m_41784_().m_128359_(DEFAULT_COVER, Registry.f_122824_.m_7981_((Object)cover).toString());
        return covered;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, BlockStateProperties.f_61362_});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        String flavourKey = this.m_7705_() + ".flavour";
        if (I18n.m_118936_((String)flavourKey)) {
            tooltip.add((Component)Component.m_237115_((String)flavourKey));
        }
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        super.onIEBlockPlacedBy(context, state);
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ConveyorBeltBlockEntity) {
            ConveyorHandler.IConveyorBlockEntity convUp;
            ConveyorHandler.IConveyorBlockEntity outputConv;
            ConveyorBeltBlockEntity conveyor = (ConveyorBeltBlockEntity)tile;
            Object conveyorInst = conveyor.getConveyorInstance();
            if (conveyorInst != null) {
                conveyorInst.setCover(ConveyorBlock.getCover(context.m_43722_()));
            }
            Direction f = conveyor.getFacing();
            tile = world.m_7702_(pos.m_121945_(f));
            BlockEntity tileUp = world.m_7702_(pos.m_121945_(f).m_7918_(0, 1, 0));
            Object subType = conveyor.getConveyorInstance();
            if (subType != null && (!(tile instanceof ConveyorHandler.IConveyorBlockEntity) || (outputConv = (ConveyorHandler.IConveyorBlockEntity)tile).getFacing() == f.m_122424_()) && tileUp instanceof ConveyorHandler.IConveyorBlockEntity && (convUp = (ConveyorHandler.IConveyorBlockEntity)tileUp).getFacing() != f.m_122424_() && world.m_46859_(pos.m_7918_(0, 1, 0))) {
                subType.setConveyorDirection(ConveyorHandler.ConveyorDirection.UP);
            }
        }
    }

    public static Block getCover(ItemStack conveyor) {
        ResourceLocation coverID = new ResourceLocation(ItemNBTHelper.getString(conveyor, DEFAULT_COVER));
        Block result = (Block)ForgeRegistries.BLOCKS.getValue(coverID);
        if (result != null) {
            return result;
        }
        return Blocks.f_50016_;
    }

    @Override
    public IConveyorType<?> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (this.type.isTicking()) {
            return super.m_142354_(world, state, type);
        }
        return null;
    }
}

