/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidPlacerBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IScrewdriverInteraction {
    private final Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);
    public FluidTank tank;
    public boolean redstoneControlInverted;
    private int tickCount;
    private final HashSet<BlockPos> checkedPositions;
    private final TreeMap<Integer, Queue<BlockPos>> layeredPlacementQueue;
    private final Queue<BlockPos> tempFluids;
    private final ResettableCapability<IFluidHandler> tankCap;

    public FluidPlacerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLUID_PLACER.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.OUTPUT);
        }
        this.sideConfig.put(Direction.UP, IEEnums.IOSideConfig.INPUT);
        this.tank = new FluidTank(4000);
        this.redstoneControlInverted = false;
        this.tickCount = 0;
        this.checkedPositions = new HashSet();
        this.layeredPlacementQueue = new TreeMap();
        this.tempFluids = new LinkedList<BlockPos>();
        this.tankCap = this.registerCapability(this.tank);
    }

    @Override
    public void tickServer() {
        if (this.isRSPowered() ^ this.redstoneControlInverted) {
            return;
        }
        if (this.tickCount % 16 == 0) {
            if (this.tickCount % 512 == 0) {
                this.prepareAreaCheck();
            }
            if (this.tank.getFluidAmount() >= 1000 && !this.layeredPlacementQueue.isEmpty()) {
                Queue<BlockPos> lowestLayer = this.layeredPlacementQueue.firstEntry().getValue();
                if (lowestLayer == null || lowestLayer.isEmpty()) {
                    this.layeredPlacementQueue.pollFirstEntry();
                } else {
                    BlockPos targetPos = lowestLayer.poll();
                    if (this.canFill(targetPos) && this.tank.getFluid().getFluid().getFluidType().canBePlacedInLevel((BlockAndTintGetter)this.f_58857_, targetPos, this.tank.getFluid()) && FluidPlacerBlockEntity.place(targetPos, this.tank, this.f_58857_)) {
                        this.addConnectedSpaces(targetPos);
                        this.handleTempFluids();
                    }
                }
            }
        }
        ++this.tickCount;
    }

    private static boolean place(BlockPos pos, FluidTank tank, Level world) {
        if (tank.getFluidAmount() < 1000) {
            return false;
        }
        FluidStack stack = tank.getFluid();
        Item bucket = stack.getFluid().m_6859_();
        if (!(bucket instanceof BucketItem)) {
            return false;
        }
        BucketItem bucketitem = (BucketItem)bucket;
        if (bucketitem == Items.f_41852_) {
            return false;
        }
        ItemStack bucketStack = new ItemStack((ItemLike)bucketitem);
        if (bucketitem.m_142073_(null, world, pos, null)) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            bucketitem.m_142131_(null, world, bucketStack, pos);
            return true;
        }
        return false;
    }

    private void prepareAreaCheck() {
        this.checkedPositions.clear();
        this.layeredPlacementQueue.clear();
        this.tempFluids.clear();
        this.addConnectedSpaces(this.m_58899_());
        this.handleTempFluids();
    }

    private Queue<BlockPos> getQueueForYLevel(int yLevel) {
        return this.layeredPlacementQueue.computeIfAbsent(yLevel, k -> new LinkedList());
    }

    private void addConnectedSpaces(BlockPos pos) {
        for (Direction facing : Direction.values()) {
            if (facing == Direction.UP || pos == this.m_58899_() && this.sideConfig.get(facing) != IEEnums.IOSideConfig.OUTPUT) continue;
            this.addToQueue(pos.m_121945_(facing));
        }
    }

    private void addToQueue(BlockPos pos) {
        if (!this.getLevelNonnull().m_151570_(pos) && this.checkedPositions.add(pos) && pos.m_123331_((Vec3i)this.m_58899_()) < 4096.0) {
            if (this.fluidMatches(pos)) {
                this.tempFluids.add(pos);
            }
            if (this.canFill(pos)) {
                this.getQueueForYLevel(pos.m_123342_()).add(pos);
            }
        }
    }

    private boolean fluidMatches(BlockPos targetPos) {
        if (!this.f_58857_.isAreaLoaded(targetPos, 1) || this.tank.getFluid().isEmpty()) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(targetPos);
        return state.m_60819_().m_76152_() == this.tank.getFluid().getFluid();
    }

    private boolean canFill(BlockPos targetPos) {
        boolean canFill;
        if (!this.f_58857_.isAreaLoaded(targetPos, 1)) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(targetPos);
        if (this.isFullFluidBlock(targetPos, state)) {
            return false;
        }
        boolean bl = canFill = !state.m_60767_().m_76333_();
        if (!canFill && state.m_60734_() instanceof SimpleWaterloggedBlock) {
            canFill = ((SimpleWaterloggedBlock)state.m_60734_()).m_6044_((BlockGetter)this.f_58857_, targetPos, state, this.tank.getFluid().getFluid());
        }
        return canFill;
    }

    private void handleTempFluids() {
        while (!this.tempFluids.isEmpty()) {
            this.addConnectedSpaces(this.tempFluids.poll());
        }
    }

    private boolean isFullFluidBlock(BlockPos pos, BlockState state) {
        return state.m_60819_().m_76170_();
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        CompoundTag sideConfigNBT = nbt.m_128469_("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigNBT.m_128451_(d.m_7912_())]);
        }
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.redstoneControlInverted = nbt.m_128471_("redstoneInverted");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        CompoundTag sideConfigNBT = new CompoundTag();
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigNBT.m_128405_(d.m_7912_(), this.sideConfig.get(d).ordinal());
        }
        nbt.m_128365_("sideConfig", (Tag)sideConfigNBT);
        nbt.m_128379_("redstoneInverted", this.redstoneControlInverted);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, Player p) {
        this.sideConfig.computeIfPresent(side, (s, conf) -> IEEnums.IOSideConfig.next(conf));
        this.prepareAreaCheck();
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
        return true;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.f_58857_.f_46443_) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER && (facing == null || this.sideConfig.get(facing) == IEEnums.IOSideConfig.INPUT)) {
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult rtr, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && rtr instanceof BlockHitResult) {
            BlockHitResult brtr = (BlockHitResult)rtr;
            IEEnums.IOSideConfig here = this.sideConfig.get(brtr.m_82434_());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(brtr.m_82434_().m_122424_());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", here, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }
}

