/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.stone.BlastFurnaceBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BlastFurnaceAdvancedBlockEntity
extends BlastFurnaceBlockEntity<BlastFurnaceAdvancedBlockEntity>
implements IEClientTickableBE {
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.f_58858_.m_5484_(this.getFacing(), 2).m_7918_(0, -1, 0), this.getFacing().m_122424_()), ForgeCapabilities.ITEM_HANDLER);
    private final CapabilityReference<IItemHandler> slag = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.f_58858_.m_5484_(this.getFacing(), -2).m_7918_(0, -1, 0), this.getFacing().m_122424_()), ForgeCapabilities.ITEM_HANDLER);
    private final MultiblockCapability<IItemHandler> inputHandler = MultiblockCapability.make(this, be -> be.inputHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, true}, new boolean[]{false, false})));
    private final MultiblockCapability<IItemHandler> outputHandler = MultiblockCapability.make(this, be -> be.outputHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(1, (IIEInventory)this, 2, new boolean[]{false}, new boolean[]{true})));
    private final MultiblockCapability<IItemHandler> slagHandler = MultiblockCapability.make(this, be -> be.slagHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(1, (IIEInventory)this, 3, new boolean[]{false}, new boolean[]{true})));
    private static final BlockPos outputOffset = new BlockPos(1, 0, 2);
    private static final BlockPos slagOutputOffset = new BlockPos(1, 0, 0);
    private static final BlockPos inputOffset = new BlockPos(1, 3, 1);
    private static final Set<BlockPos> ioOffsets = ImmutableSet.of((Object)inputOffset, (Object)outputOffset, (Object)slagOutputOffset);

    public BlastFurnaceAdvancedBlockEntity(BlockEntityType<BlastFurnaceAdvancedBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.ADVANCED_BLAST_FURNACE, type, pos, state);
    }

    @Override
    public IEMenuTypes.BEContainer<BlastFurnaceBlockEntity<?>, ?> getContainerType() {
        return IEMenuTypes.BLAST_FURNACE_ADV;
    }

    @Override
    public void tickClient() {
        if (this.isDummy()) {
            return;
        }
        if (this.getIsActive()) {
            this.f_58857_.m_7107_((ParticleOptions)ParticleTypes.f_123777_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 2.9, (double)this.m_58899_().m_123343_() + 0.5, ApiUtils.RANDOM.nextDouble() * 0.0125 - 0.00625, 0.05, ApiUtils.RANDOM.nextDouble() * 0.0125 - 0.00625);
        }
    }

    @Override
    public void tickServer() {
        ItemStack stack;
        super.tickServer();
        if (this.f_58857_.m_46467_() % 8L != 0L || this.isDummy()) {
            return;
        }
        if (!((ItemStack)this.inventory.get(2)).m_41619_()) {
            stack = (ItemStack)this.inventory.get(2);
            stack = Utils.insertStackIntoInventory(this.output, stack, false);
            this.inventory.set(2, (Object)stack);
        }
        if (!((ItemStack)this.inventory.get(3)).m_41619_()) {
            stack = (ItemStack)this.inventory.get(3);
            stack = Utils.insertStackIntoInventory(this.slag, stack, false);
            this.inventory.set(3, (Object)stack);
        }
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (this.posInMultiblock.m_123341_() == 1 && this.posInMultiblock.m_123343_() == 1 || ImmutableSet.of((Object)new BlockPos(1, 0, 2), (Object)new BlockPos(1, 1, 2), (Object)new BlockPos(1, 3, 1)).contains((Object)this.posInMultiblock)) {
            return Shapes.m_83144_();
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (new BlockPos(1, 0, 0).equals((Object)this.posInMultiblock)) {
            xMin = this.getFacing().m_122434_() == Direction.Axis.Z ? 0.1875f : 0.0f;
            xMax = this.getFacing().m_122434_() == Direction.Axis.Z ? 0.8125f : 1.0f;
            zMin = this.getFacing().m_122434_() == Direction.Axis.X ? 0.1875f : 0.0f;
            zMax = this.getFacing().m_122434_() == Direction.Axis.X ? 0.8125f : 1.0f;
            yMax = 0.8125f;
        } else {
            float indent = 1.0f;
            if (this.posInMultiblock.m_123342_() == 0) {
                indent = this.posInMultiblock.m_123343_() == 1 ? 0.5f : 0.3125f;
            } else if (this.posInMultiblock.m_123342_() == 1) {
                indent = 0.5f;
            } else if (this.posInMultiblock.m_123342_() == 2) {
                indent = 0.375f;
            }
            if (this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.WEST || this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.EAST || this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.NORTH) {
                xMin = 1.0f - indent;
            }
            if (this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.EAST || this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.WEST || this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.NORTH || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.SOUTH) {
                xMax = indent;
            }
            if (this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.NORTH || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.EAST || this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.WEST) {
                zMin = 1.0f - indent;
            }
            if (this.posInMultiblock.m_123343_() == 0 && this.getFacing() == Direction.NORTH || this.posInMultiblock.m_123343_() == 2 && this.getFacing() == Direction.SOUTH || this.posInMultiblock.m_123341_() == 2 && this.getFacing() == Direction.WEST || this.posInMultiblock.m_123341_() == 0 && this.getFacing() == Direction.EAST) {
                zMax = indent;
            }
        }
        return Shapes.m_83048_((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }

    @Override
    protected int getProcessSpeed() {
        int i = 1;
        for (int j = 0; j < 2; ++j) {
            i += this.getFromPreheater(j == 0, BlastFurnacePreheaterBlockEntity::doSpeedup, 0).intValue();
        }
        return i;
    }

    public <V> V getFromPreheater(boolean left, Function<BlastFurnacePreheaterBlockEntity, V> getter, V orElse) {
        return this.getPreheater(left).map(getter).orElse(orElse);
    }

    public Optional<BlastFurnacePreheaterBlockEntity> getPreheater(boolean left) {
        Direction phf = left ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
        BlockPos pos = this.m_58899_().m_7918_(0, -1, 0).m_5484_(phf, 2);
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, pos);
        if (te instanceof BlastFurnacePreheaterBlockEntity) {
            return Optional.of((BlastFurnacePreheaterBlockEntity)te);
        }
        return Optional.empty();
    }

    @Override
    protected void turnOff() {
        super.turnOff();
        for (int j = 0; j < 2; ++j) {
            this.getFromPreheater(j == 0, BlastFurnacePreheaterBlockEntity::turnOff, 0);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ioOffsets.contains(this.posInMultiblock) && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (inputOffset.equals((Object)this.posInMultiblock) && facing == Direction.UP) {
                return this.inputHandler.getAndCast();
            }
            if (outputOffset.equals((Object)this.posInMultiblock) && facing == this.getFacing()) {
                return this.outputHandler.getAndCast();
            }
            if (slagOutputOffset.equals((Object)this.posInMultiblock) && facing == this.getFacing().m_122424_()) {
                return this.slagHandler.getAndCast();
            }
        }
        return super.getCapability(capability, facing);
    }
}

