/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class GeneratorFuelSerializer
extends IERecipeSerializer<GeneratorFuel> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.DIESEL_GENERATOR);
    }

    @Override
    public GeneratorFuel readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        ResourceLocation tagName = new ResourceLocation(json.get("fluidTag").getAsString());
        TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)tagName);
        int amount = json.get("burnTime").getAsInt();
        return new GeneratorFuel(recipeId, (TagKey<Fluid>)tag, amount);
    }

    @Nullable
    public GeneratorFuel fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        List<Fluid> fluids = PacketUtils.readList(buffer, buf -> (Fluid)buf.readRegistryIdUnsafe(ForgeRegistries.FLUIDS));
        int burnTime = buffer.readInt();
        return new GeneratorFuel(recipeId, fluids, burnTime);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull GeneratorFuel recipe) {
        PacketUtils.writeList(buffer, recipe.getFluids(), (f, buf) -> buf.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, f));
        buffer.writeInt(recipe.getBurnTime());
    }
}

