/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class BuzzsawItem
extends DieselToolItem
implements IEItemInterfaces.IScrollwheel {
    public static final Collection<SawbladeItem> SAWBLADES = new ArrayList<SawbladeItem>(2);
    private static final Map<ToolAction, SoundEvent> ACTION_SOUNDS = new HashMap<ToolAction, SoundEvent>();
    private static final int MAX_HORIZONTAL_DISTANCE = 7;

    public BuzzsawItem() {
        super(new Item.Properties().m_41487_(1), "BUZZSAW");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Override
    public int getSlotCount() {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        boolean hasQuiver = BuzzsawItem.hasQuiverUpgrade(stack);
        int mainHeadX = hasQuiver ? 88 : 98;
        ArrayList<SlotItemHandler> slots = new ArrayList<SlotItemHandler>(5);
        slots.add(new IESlot.WithPredicate(toolInventory, 0, mainHeadX, 22, BuzzsawItem::isSawblade, newBlade -> this.setHead(stack, (ItemStack)newBlade)));
        slots.add(new IESlot.Upgrades(container, toolInventory, 1, 88, 52, "BUZZSAW", stack, true, level, getPlayer));
        slots.add(new IESlot.Upgrades(container, toolInventory, 2, 108, 52, "BUZZSAW", stack, true, level, getPlayer));
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            slots.add(new IESlot.WithPredicate(toolInventory, 3, 108, 12, BuzzsawItem::isSawblade));
            slots.add(new IESlot.WithPredicate(toolInventory, 4, 108, 32, BuzzsawItem::isSawblade));
        }
        return slots.toArray(new Slot[0]);
    }

    @Override
    public ItemStack getUpgradeAfterRemoval(ItemStack stack, ItemStack upgrade) {
        this.forEachSpareBlade(stack, upgrade, (i, sawblade) -> {
            if (sawblade.m_41619_()) {
                ItemNBTHelper.remove(upgrade, "sawblade" + i);
            } else {
                ItemNBTHelper.setItemStack(upgrade, "sawblade" + i, sawblade);
            }
        });
        return upgrade;
    }

    @Override
    public void removeUpgrade(ItemStack stack, Player player, ItemStack upgrade) {
        this.forEachSpareBlade(stack, upgrade, (i, $) -> this.setSawblade(stack, ItemStack.f_41583_, (int)i));
    }

    private void forEachSpareBlade(ItemStack stack, ItemStack upgrade, BiConsumer<Integer, ItemStack> onBlade) {
        if (upgrade.m_41720_() == IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES).m_5456_()) {
            for (int i = 1; i <= 2; ++i) {
                ItemStack sawblade = BuzzsawItem.getSawblade(stack, i);
                onBlade.accept(i, sawblade);
            }
        }
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        invCap.ifPresent(inv -> {
            if (!(inv.getStackInSlot(0).m_41619_() || inv.getStackInSlot(1).m_41619_() || inv.getStackInSlot(2).m_41619_())) {
                Utils.unlockIEAdvancement(player, "tools/upgrade_buzzsaw");
            }
        });
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        super.recalculateUpgrades(stack, w, player);
        LazyOptional invCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        invCap.ifPresent(inv -> {
            for (int iUpgrade = 1; iUpgrade <= 2; ++iUpgrade) {
                ItemStack upgrade = inv.getStackInSlot(iUpgrade);
                if (upgrade.m_41720_() != IEItems.Misc.TOOL_UPGRADES.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES).m_5456_()) continue;
                for (int i = 1; i <= 2; ++i) {
                    if (!ItemNBTHelper.hasKey(upgrade, "sawblade" + i)) continue;
                    ItemStack sawblade = ItemNBTHelper.getItemStack(upgrade, "sawblade" + i);
                    this.setSawblade(stack, sawblade, i);
                    ItemNBTHelper.remove(upgrade, "sawblade" + i);
                }
            }
        });
    }

    @Override
    public ItemStack getHead(ItemStack itemStack) {
        return BuzzsawItem.getSawblade(itemStack, 0);
    }

    public static ItemStack getSawblade(ItemStack itemStack, int spare) {
        if (ForgeCapabilities.ITEM_HANDLER == null) {
            return ItemStack.f_41583_;
        }
        LazyOptional cap = itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        int slot = spare == 0 ? 0 : 2 + spare;
        ItemStack sawblade = ((IItemHandler)cap.orElseThrow(RuntimeException::new)).getStackInSlot(slot);
        return !sawblade.m_41619_() && BuzzsawItem.isSawblade(sawblade) ? sawblade : ItemStack.f_41583_;
    }

    @Override
    public void setHead(ItemStack buzzsaw, ItemStack sawblade) {
        this.setSawblade(buzzsaw, sawblade, 0);
    }

    public void setSawblade(ItemStack buzzsaw, ItemStack sawblade, int spare) {
        int slot = spare == 0 ? 0 : 2 + spare;
        IItemHandler inv = (IItemHandler)CapabilityUtils.getPresentCapability((ICapabilityProvider)buzzsaw, ForgeCapabilities.ITEM_HANDLER);
        ((IItemHandlerModifiable)inv).setStackInSlot(slot, sawblade);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return this.getAllEnchantments(stack).getOrDefault(enchantment, 0);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        ItemStack sawblade = BuzzsawItem.getSawblade(stack, 0);
        Map superEnchants = super.getAllEnchantments(stack);
        Item item = sawblade.m_41720_();
        if (item instanceof SawbladeItem) {
            SawbladeItem blade = (SawbladeItem)item;
            blade.modifyEnchants(superEnchants);
        }
        return superEnchants;
    }

    @Override
    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        for (int i = 1; i <= 2; ++i) {
            ItemStack spare = BuzzsawItem.getSawblade(stack, i);
            if (spare.m_41619_()) continue;
            ret.m_128365_("spare" + i, (Tag)spare.m_41739_(new CompoundTag()));
        }
        return ret;
    }

    @Override
    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            for (int i = 1; i <= 2; ++i) {
                if (!nbt.m_128441_("spare" + i)) continue;
                this.setSawblade(stack, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("spare" + i)), i);
                nbt.m_128473_("spare" + i);
            }
        }
        super.readShareTag(stack, nbt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).m_41619_()) {
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.buzzsaw.noBlade"), ChatFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            ChatFormatting status = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.buzzsaw.bladeDamage"), ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersiveengineering.info.percent", (Object[])new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.COMMON;
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack sawblade) {
        return ((SawbladeItem)sawblade.m_41720_()).getSawbladeDamage();
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player playerEntity, boolean forward) {
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            ItemStack sawblade = this.getHead(stack);
            ItemStack spare1 = BuzzsawItem.getSawblade(stack, 1);
            ItemStack spare2 = BuzzsawItem.getSawblade(stack, 2);
            if (forward) {
                this.setHead(stack, spare2);
                this.setSawblade(stack, sawblade, 1);
                this.setSawblade(stack, spare1, 2);
            } else {
                this.setHead(stack, spare1);
                this.setSawblade(stack, spare2, 1);
                this.setSawblade(stack, sawblade, 2);
            }
        }
    }

    @Override
    public boolean canToolBeUsed(ItemStack stack) {
        if (this.getHeadDamage(stack) >= this.getMaxHeadDamage(stack)) {
            return false;
        }
        return !this.getFluid(stack).isEmpty();
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        return !sawblade.m_41619_() ? sawblade.m_41776_() : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        return !sawblade.m_41619_() ? sawblade.m_41773_() : 0;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity living) {
        this.consumeDurability(stack, world, state, pos, living);
        if (!world.f_46443_ && !living.m_6144_() && living instanceof ServerPlayer && this.canFellTree(stack) && this.canToolBeUsed(stack) && this.isTree(world, pos) && !state.m_204336_(IETags.buzzsawTreeBlacklist)) {
            this.fellTree(world, pos, (ServerPlayer)living, stack);
        }
        return true;
    }

    @Override
    protected int getToolDamageFromBlock(ItemStack stack, @Nullable BlockState state) {
        ItemStack sawblade = this.getHead(stack);
        Item item = sawblade.m_41720_();
        if (item instanceof SawbladeItem) {
            SawbladeItem sawbladeItem = (SawbladeItem)item;
            return sawbladeItem.getSawbladeDamageFromBlock(state == null || this.isEffective(stack, state));
        }
        return 0;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        head.m_41622_(amount, living, entity -> entity.m_21190_(InteractionHand.MAIN_HAND));
    }

    @Override
    protected void consumeDurability(ItemStack stack, Level world, @Nullable BlockState state, @Nullable BlockPos pos, LivingEntity living) {
        if (state == null || !state.m_204336_(BlockTags.f_13035_) || ApiUtils.RANDOM.nextInt(10) == 0) {
            super.consumeDurability(stack, world, state, pos, living);
        }
    }

    @Override
    public Tier getHarvestLevel(ItemStack stack, @Nullable Player player) {
        ItemStack sawblade = this.getHead(stack);
        if (!sawblade.m_41619_()) {
            return Tiers.DIAMOND;
        }
        return null;
    }

    @Override
    public boolean isEffective(ItemStack stack, BlockState state) {
        Predicate<BlockState> mineable = null;
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.m_41720_() instanceof SawbladeItem) {
            mineable = ((SawbladeItem)sawblade.m_41720_()).getSawbladeMaterials();
        }
        return mineable != null && mineable.test(state);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        ItemStack sawblade;
        if (this.isEffective(stack, state) && !(sawblade = this.getHead(stack)).m_41619_() && this.canToolBeUsed(stack)) {
            return ((SawbladeItem)sawblade.m_41720_()).getSawbladeSpeed();
        }
        return super.m_8102_(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.m_41720_() instanceof SawbladeItem) {
            return ((SawbladeItem)sawblade.m_41720_()).getToolActions().contains(toolAction);
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack head = this.getHead(context.m_43722_());
        Item item = head.m_41720_();
        if (!(item instanceof SawbladeItem)) {
            return InteractionResult.PASS;
        }
        SawbladeItem sawblade = (SawbladeItem)item;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Set<ToolAction> toolActions = sawblade.getToolActions();
        for (ToolAction action : toolActions) {
            BlockState transformed = state.getToolModifiedState(context, action, false);
            if (transformed == null) continue;
            SoundEvent sound = ACTION_SOUNDS.get(action);
            if (sound != null) {
                level.m_5594_(context.m_43723_(), pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!level.f_46443_) {
                level.m_7731_(pos, transformed, 11);
                if (context.m_43723_() != null) {
                    this.damageHead(head, 1, (LivingEntity)context.m_43723_());
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private boolean isTree(Level world, BlockPos initialPos) {
        int logs = 0;
        boolean leafTop = false;
        BlockPos pos = initialPos;
        for (int y = 0; y < 32; ++y) {
            BlockState state = world.m_8055_(pos = pos.m_7494_());
            if (state.m_204336_(BlockTags.f_13106_)) {
                ++logs;
                continue;
            }
            if (state.m_204336_(BlockTags.f_13035_)) {
                leafTop = true;
            }
            boolean foundLog = false;
            if (!leafTop) {
                boolean loop = true;
                for (int z = -1; z <= 1 && loop; ++z) {
                    for (int x = -1; x <= 1 && loop; ++x) {
                        state = world.m_8055_(pos.m_7918_(x, 0, z));
                        if (!state.m_204336_(BlockTags.f_13106_)) continue;
                        pos = pos.m_7918_(x, 0, z);
                        foundLog = true;
                        ++logs;
                        loop = false;
                    }
                }
            }
            if (!foundLog) break;
        }
        return logs >= 3 && leafTop;
    }

    private boolean canFellTree(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.m_41720_() instanceof SawbladeItem) {
            return ((SawbladeItem)sawblade.m_41720_()).canSawbladeFellTree();
        }
        return false;
    }

    private boolean fellTree(final Level world, BlockPos initialPos, final ServerPlayer player, final ItemStack stack) {
        int logs = 0;
        ArrayDeque<BlockPos> openList = new ArrayDeque<BlockPos>();
        final ArrayDeque<BlockPos> closedList = new ArrayDeque<BlockPos>();
        openList.add(initialPos);
        while (!openList.isEmpty() && closedList.size() < 512 && logs < 256) {
            BlockPos next = (BlockPos)openList.pollFirst();
            if (Math.abs(next.m_123341_() - initialPos.m_123341_()) > 7 || Math.abs(next.m_123343_() - initialPos.m_123343_()) > 7 || closedList.contains(next)) continue;
            BlockState state = world.m_8055_(next);
            if (state.m_204336_(BlockTags.f_13106_)) {
                closedList.add(next);
                ++logs;
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int x = -1; x <= 1; ++x) {
                            openList.add(next.m_7918_(x, y, z));
                        }
                    }
                }
                continue;
            }
            if (!state.m_204336_(BlockTags.f_13035_)) continue;
            closedList.add(next);
            int trunkDist = state.m_60734_() instanceof LeavesBlock ? (Integer)state.m_61143_((Property)LeavesBlock.f_54418_) : 0;
            for (Direction dir : new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
                BlockPos adj = next.m_121945_(dir);
                BlockState adjState = world.m_8055_(adj);
                if (adjState.m_204336_(BlockTags.f_13035_)) {
                    int adjDist;
                    int n = adjDist = adjState.m_60734_() instanceof LeavesBlock ? (Integer)adjState.m_61143_((Property)LeavesBlock.f_54418_) : 0;
                    if (adjDist < trunkDist) continue;
                }
                openList.add(adj);
            }
        }
        if (closedList.size() == 0) {
            return false;
        }
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onTick(TickEvent.LevelTickEvent event) {
                if (event.phase == TickEvent.Phase.START && event.level == world) {
                    BuzzsawItem.this.breakFromList(closedList, 5, world, player, stack);
                    if (closedList.isEmpty()) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        });
        return true;
    }

    private void breakFromList(Deque<BlockPos> closedList, int maxAmount, Level world, ServerPlayer player, ItemStack stack) {
        int count = 0;
        while (count++ < maxAmount && !closedList.isEmpty()) {
            BlockPos pos = closedList.pollFirst();
            int xpDropEvent = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)player.f_8941_.m_9290_(), (ServerPlayer)player, (BlockPos)pos);
            if (xpDropEvent < 0) continue;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (state.m_60795_() || state.m_60625_((Player)player, (BlockGetter)world, pos) == 0.0f) continue;
            if (player.m_150110_().f_35937_) {
                if (block.onDestroyedByPlayer(state, world, pos, (Player)player, false, state.m_60819_())) {
                    block.m_6786_((LevelAccessor)world, pos, state);
                }
            } else {
                BlockEntity te = world.m_7702_(pos);
                this.consumeDurability(stack, world, state, pos, (LivingEntity)player);
                if (block.onDestroyedByPlayer(state, world, pos, (Player)player, true, state.m_60819_())) {
                    block.m_6786_((LevelAccessor)world, pos, state);
                    block.m_6240_(world, (Player)player, pos, state, te, stack);
                    if (world instanceof ServerLevel) {
                        block.m_49805_((ServerLevel)world, pos, xpDropEvent);
                    }
                }
            }
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            player.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        }
    }

    public static boolean hasQuiverUpgrade(ItemStack stack) {
        return IEItems.Tools.BUZZSAW.get().getUpgrades(stack).m_128471_("spareblades");
    }

    public static boolean isSawblade(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof SawbladeItem && SAWBLADES.contains(item);
    }

    static {
        ACTION_SOUNDS.put(ToolActions.AXE_STRIP, SoundEvents.f_11688_);
        ACTION_SOUNDS.put(ToolActions.AXE_SCRAPE, SoundEvents.f_144059_);
        ACTION_SOUNDS.put(ToolActions.AXE_WAX_OFF, SoundEvents.f_144060_);
        ACTION_SOUNDS.put(ToolActions.SHEARS_CARVE, SoundEvents.f_12296_);
    }
}

