/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry;

import com.sk89q.worldedit.registry.Keyed;
import java.util.HashSet;
import java.util.Set;

public abstract class Category<T extends Keyed> {
    private final Set<T> set = new HashSet<T>();
    protected final String id;
    private boolean empty = true;

    protected Category(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public final Set<T> getAll() {
        if (this.empty) {
            this.set.addAll(this.load());
            this.empty = false;
        }
        return this.set;
    }

    protected abstract Set<T> load();

    public boolean contains(T object) {
        return this.getAll().contains(object);
    }

    public void invalidateCache() {
        this.set.clear();
        this.empty = true;
    }

    public String toString() {
        return this.getId();
    }
}

