/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Chimney
extends Container
implements ITiledBlock<Container.Tile> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> SIDES = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    public final boolean isNarrow;
    public final int radius;
    public final int wallThickness;
    protected final Map<BlockState, VoxelShape> shapesCache;

    public Chimney(Properties<?> props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true)));
        this.isNarrow = props.isNarrow;
        this.radius = props.radius;
        this.wallThickness = props.wallThickness;
        this.shapesCache = this.m_152458_(this::calculateShapeFor);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TOP, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        state = this.updateTop((LevelReader)level, state, pos);
        for (Direction direction : GameWorld.Directions.of().horizontals().toList()) {
            state = this.updateSide((LevelReader)level, state, pos, direction);
        }
        return state;
    }

    protected VoxelShape calculateShapeFor(BlockState state) {
        return SIDES.entrySet().stream().filter(entry -> state.m_61138_((Property)entry.getValue())).map(entry -> this.makeSideShape((Direction)entry.getKey(), (Boolean)state.m_61143_((Property)entry.getValue()))).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    protected VoxelShape makeSideShape(Direction side, boolean exists) {
        VoxelShape shape;
        int minXZ = this.isNarrow ? 8 - (this.radius - 1) : 8 - this.radius;
        int maxXZ = this.isNarrow ? 8 + (this.radius - 1) : 8 + this.radius;
        switch (side) {
            case NORTH: {
                VoxelShape voxelShape = Block.m_49796_((double)minXZ, (double)0.0, (double)minXZ, (double)maxXZ, (double)16.0, (double)(minXZ + this.wallThickness));
                break;
            }
            case SOUTH: {
                VoxelShape voxelShape = Block.m_49796_((double)minXZ, (double)0.0, (double)(maxXZ - this.wallThickness), (double)maxXZ, (double)16.0, (double)maxXZ);
                break;
            }
            case WEST: {
                VoxelShape voxelShape = Block.m_49796_((double)minXZ, (double)0.0, (double)minXZ, (double)(minXZ + this.wallThickness), (double)16.0, (double)maxXZ);
                break;
            }
            case EAST: {
                VoxelShape voxelShape = Block.m_49796_((double)(maxXZ - this.wallThickness), (double)0.0, (double)minXZ, (double)maxXZ, (double)16.0, (double)maxXZ);
                break;
            }
            default: {
                VoxelShape voxelShape = shape = Shapes.m_83040_();
            }
        }
        if (!exists) {
            int hw = this.isNarrow ? this.wallThickness : this.wallThickness + 1;
            int thic = minXZ + this.wallThickness;
            VoxelShape bridge = switch (side) {
                case Direction.NORTH -> Block.m_49796_((double)minXZ, (double)0.0, (double)0.0, (double)maxXZ, (double)16.0, (double)thic);
                case Direction.SOUTH -> Block.m_49796_((double)minXZ, (double)0.0, (double)(16 - thic), (double)maxXZ, (double)16.0, (double)16.0);
                case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)minXZ, (double)thic, (double)16.0, (double)maxXZ);
                case Direction.EAST -> Block.m_49796_((double)(16 - thic), (double)0.0, (double)minXZ, (double)16.0, (double)16.0, (double)maxXZ);
                default -> Shapes.m_83040_();
            };
            VoxelShape hole = switch (side) {
                case Direction.NORTH -> Block.m_49796_((double)(minXZ + hw), (double)0.0, (double)0.0, (double)(maxXZ - hw), (double)(16 - hw), (double)thic);
                case Direction.SOUTH -> Block.m_49796_((double)(minXZ + hw), (double)0.0, (double)(16 - thic), (double)(maxXZ - hw), (double)(16 - hw), (double)16.0);
                case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)(minXZ + hw), (double)thic, (double)(16 - hw), (double)(maxXZ - hw));
                case Direction.EAST -> Block.m_49796_((double)(16 - thic), (double)0.0, (double)(minXZ + hw), (double)16.0, (double)(16 - hw), (double)(maxXZ - hw));
                default -> Shapes.m_83040_();
            };
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)bridge, (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)hole, (BooleanOp)BooleanOp.f_82685_);
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        BlockState state = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        state = this.updateTop((LevelReader)pLevel, state, pPos);
        if (pDirection.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            state = this.updateSide((LevelReader)pLevel, state, pPos, pDirection);
        }
        return state;
    }

    protected BlockState updateTop(LevelReader level, BlockState state, BlockPos pos) {
        boolean chimneyAbove = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos.m_7494_());
        return (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(!chimneyAbove));
    }

    /*
     * Unable to fully structure code
     */
    protected BlockState updateSide(LevelReader level, BlockState state, BlockPos pos, Direction facing) {
        facingPos = pos.m_121945_(facing);
        if (this.isNarrow || !GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)facingPos) || !((var8_6 = level.m_8055_(facingPos).m_60734_()) instanceof Chimney)) ** GOTO lbl-1000
        chimney = (Chimney)var8_6;
        if (!chimney.isNarrow) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = connected = false;
        }
        if (!connected) {
            connected = AdChimneys.getInstance().emitters.get(level, facingPos).isPresent();
        }
        return (BlockState)state.m_61124_((Property)Chimney.SIDES.get(facing), (Comparable)Boolean.valueOf(connected == false));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return switch (pRot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)));
            default -> pState;
        };
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)((Boolean)pState.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)pState.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.m_61124_((Property)EAST, (Comparable)((Boolean)pState.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)pState.m_61143_((Property)EAST)));
            default -> super.m_6943_(pState, pMirror);
        };
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        int opacity;
        int n = opacity = state.m_60767_().m_76337_() && state.m_60827_() != SoundType.f_56744_ ? 1 : 0;
        if (!this.m_7420_(state, worldIn, pos)) {
            ++opacity;
        }
        return opacity;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_61138_((Property)WATERLOGGED) && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public Container.Tile createTile(BlockPos pos, BlockState state) {
        return new Container.Tile(pos, state);
    }

    public Class<Container.Tile> getTileClass() {
        return Container.Tile.class;
    }

    public static class Properties<T extends Properties<T>>
    extends Container.Properties<T> {
        boolean isNarrow = false;
        int radius = 8;
        int wallThickness = 2;

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
            this.vanillaProps.m_60955_();
        }

        public static Properties<?> of(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        public T narrow(int radius) {
            this.isNarrow = true;
            this.radius = radius;
            return (T)((Object)((Properties)this.self));
        }

        public T wallThickness(int thickness) {
            this.wallThickness = thickness;
            return (T)((Object)((Properties)this.self));
        }
    }
}

