/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStates
extends BlockStateProvider {
    public ModBlockStates(DataGenerator generator, String modid, ExistingFileHelper exFileHelper) {
        super(generator, modid, exFileHelper);
    }

    protected void registerContainer(RegistryObject<? extends Container> container, String texture) {
        this.getVariantBuilder((Block)container.get()).forAllStatesExcept(state -> this.configuredModel(container.getId().toString(), ((Container)((Object)((Object)container.get()))).getType().getName(), texture), new Property[]{IWaterLoggable.WATERLOGGED});
    }

    protected void registerMultipartChimney(RegistryObject<Chimney> chimney, String texture, Set<ModelParts> parts) {
        String name = chimney.getId().toString();
        String parent = chimney.getId().m_135815_() + "/chimney";
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)chimney.get()).part().modelFile(this.baseModel(name, "chimney", "", texture)).addModel()).end();
        if (parts.contains((Object)ModelParts.BRIDGE)) {
            this.multipartBridges(builder, this.baseModel(name, parent, "bridge", texture));
        }
        if (parts.contains((Object)ModelParts.CORNER)) {
            this.multipartCorners(builder, this.baseModel(name, parent, "corner", texture), false);
        }
        if (parts.contains((Object)ModelParts.TOP_CORNER)) {
            this.multipartCorners(builder, this.baseModel(name, parent, "top_corner", texture), true);
        }
        if (parts.contains((Object)ModelParts.SIDE)) {
            this.multipartSides(builder, this.baseModel(name, parent, "side", texture), false);
        }
        if (parts.contains((Object)ModelParts.TOP_SIDE)) {
            this.multipartSides(builder, this.baseModel(name, parent, "top_side", texture), true);
        }
        this.baseModel(name, parent, "inventory", texture);
    }

    protected ModelFile baseModel(String name, String parent, String suffix, String texture) {
        return this.baseModel(Names.registry().join(new String[]{name, suffix}), Names.registry().join(new String[]{parent, suffix}), new String[]{texture});
    }

    protected ModelFile baseModel(String name, String parent, String[] textures) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("base/" + parent));
        for (int i = 0; i < textures.length; ++i) {
            if (i == 0) {
                model.texture("particle", textures[i]);
            }
            model.texture(String.valueOf(i), textures[i]);
        }
        return model;
    }

    protected ConfiguredModel[] configuredModel(String name, String parent, String ... textures) {
        return ConfiguredModel.builder().modelFile(this.baseModel(name, parent, textures)).build();
    }

    protected MultiPartBlockStateBuilder.PartBuilder rotatedPart(MultiPartBlockStateBuilder builder, ModelFile model, Direction direction) {
        return (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)direction.m_122435_() + 180) % 360).uvLock(true).addModel();
    }

    protected void multipartSides(MultiPartBlockStateBuilder builder, ModelFile model, boolean onlyTop) {
        Chimney.SIDES.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                MultiPartBlockStateBuilder.PartBuilder part = this.rotatedPart(builder, model, (Direction)dir);
                if (onlyTop) {
                    part.condition((Property)Chimney.TOP, (Comparable[])new Boolean[]{true});
                }
                part.condition((Property)value, (Comparable[])new Boolean[]{true});
            }
        });
    }

    protected void multipartBridges(MultiPartBlockStateBuilder builder, ModelFile model) {
        Chimney.SIDES.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                MultiPartBlockStateBuilder.PartBuilder part = this.rotatedPart(builder, model, (Direction)dir);
                part.condition((Property)value, (Comparable[])new Boolean[]{false});
            }
        });
    }

    protected Direction prevDirection(Direction current) {
        Direction[] directions = GameWorld.Directions.CLOCKWISE_HORIZONTALS;
        for (int i = 0; i < directions.length; ++i) {
            if (directions[i] != current) continue;
            if (--i < 0) {
                i += directions.length;
            }
            return directions[i];
        }
        return current;
    }

    protected void multipartCorners(MultiPartBlockStateBuilder builder, ModelFile model, boolean onlyTop) {
        Chimney.SIDES.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                MultiPartBlockStateBuilder.PartBuilder part = this.rotatedPart(builder, model, (Direction)dir);
                if (onlyTop) {
                    part.nestedGroup().condition((Property)Chimney.TOP, (Comparable[])new Boolean[]{true});
                }
                part.nestedGroup().useOr().condition((Property)value, (Comparable[])new Boolean[]{true}).condition((Property)Chimney.SIDES.get(this.prevDirection((Direction)dir)), (Comparable[])new Boolean[]{true});
            }
        });
    }

    protected void registerStatesAndModels() {
        Blocks blocks = AdChimneys.getInstance().blocks;
        this.registerMultipartChimney(blocks.cobblestone_chimney, "minecraft:block/cobblestone", ModelParts.of(ModelParts.CORNER));
        this.registerMultipartChimney(blocks.stone_chimney, "minecraft:block/stone", ModelParts.of(ModelParts.CORNER, ModelParts.TOP_CORNER, ModelParts.TOP_SIDE));
        this.registerMultipartChimney(blocks.small_brick_chimney, "minecraft:block/bricks", ModelParts.of(ModelParts.CORNER, ModelParts.TOP_CORNER, ModelParts.TOP_SIDE));
        this.registerMultipartChimney(blocks.large_brick_chimney, "minecraft:block/stone_bricks", ModelParts.of(ModelParts.CORNER, ModelParts.TOP_CORNER));
        this.registerMultipartChimney(blocks.glass_chimney, "minecraft:block/glass", ModelParts.of(ModelParts.CORNER, ModelParts.TOP_CORNER, ModelParts.TOP_SIDE));
        this.registerMultipartChimney(blocks.metal_chimney, "minecraft:block/hopper_outside", ModelParts.of(ModelParts.TOP_CORNER, ModelParts.TOP_SIDE));
        this.registerContainer(blocks.stone_vent, "minecraft:block/furnace_top");
        this.registerContainer(blocks.metal_vent, "minecraft:block/blast_furnace_top");
        this.registerContainer(blocks.stone_pump, "minecraft:block/furnace_top");
        this.registerContainer(blocks.metal_pump, "minecraft:block/blast_furnace_top");
        this.getVariantBuilder((Block)blocks.pipe.get()).forAllStatesExcept(state -> this.configuredModel("pipe", "pipe", new String[0]), new Property[]{IWaterLoggable.WATERLOGGED});
    }

    private static enum ModelParts implements IForgeEnum
    {
        BRIDGE,
        CORNER,
        TOP_CORNER,
        SIDE,
        TOP_SIDE;


        public static EnumSet<ModelParts> of(ModelParts ... parts) {
            EnumSet<ModelParts> set = EnumSet.of(BRIDGE, SIDE);
            set.addAll(Arrays.asList(parts));
            return set;
        }
    }
}

