/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Pipe;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import com.endertech.minecraft.mods.adchimneys.data.ModItemTags;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import com.endertech.minecraft.mods.adchimneys.items.Paintbrush;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class ModRecipes
extends RecipeProvider {
    public ModRecipes(DataGenerator generator) {
        super(generator);
    }

    protected void buildChimney(Chimney chimney, TagKey<Item> material, int count, Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126118_((ItemLike)chimney, (int)count).m_126130_("M M").m_126130_("M M").m_126130_("M M").m_206416_(Character.valueOf('M'), material).m_126132_("has_item", (CriterionTriggerInstance)ModRecipes.m_206406_(material)).m_176498_(output);
    }

    protected void buildNarrowChimney(Chimney chimney, TagKey<Item> material, int count, Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126118_((ItemLike)chimney, (int)count).m_126130_("MMM").m_126130_(" M ").m_126130_(" M ").m_206416_(Character.valueOf('M'), material).m_126132_("has_item", (CriterionTriggerInstance)ModRecipes.m_206406_(material)).m_176498_(output);
    }

    protected void buildVent(Vent vent, Chimney material, Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126118_((ItemLike)vent, (int)4).m_126130_("H H").m_126130_("   ").m_126130_("H H").m_126127_(Character.valueOf('H'), (ItemLike)material).m_126132_("has_item", (CriterionTriggerInstance)ModRecipes.m_125977_((ItemLike)material)).m_176498_(output);
    }

    protected void buildPump(Pump pump, Vent material, Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126118_((ItemLike)pump, (int)4).m_126130_("#R#").m_126130_("RVR").m_126130_("#R#").m_126127_(Character.valueOf('#'), (ItemLike)material).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42350_).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42155_).m_126132_("has_item", (CriterionTriggerInstance)ModRecipes.m_125977_((ItemLike)material)).m_176498_(output);
    }

    protected void buildPipe(Pipe pipe, TagKey<Item> material, int count, Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126118_((ItemLike)pipe, (int)count).m_126130_("I I").m_126130_("I I").m_126130_("I I").m_206416_(Character.valueOf('I'), material).m_126132_("has_item", (CriterionTriggerInstance)ModRecipes.m_206406_(material)).m_176498_(output);
    }

    protected void buildPaintbrush(Paintbrush paintbrush, TagKey<Item> material, Consumer<FinishedRecipe> output) {
        ShapedRecipeBuilder.m_126116_((ItemLike)paintbrush).m_126130_(" H").m_126130_("I ").m_206416_(Character.valueOf('H'), material).m_206416_(Character.valueOf('I'), Tags.Items.RODS_WOODEN).m_126132_("has_item", (CriterionTriggerInstance)ModRecipes.m_206406_(material)).m_176498_(output);
    }

    protected void m_176531_(Consumer<FinishedRecipe> output) {
        AdChimneys mod = AdChimneys.getInstance();
        Blocks blocks = mod.blocks;
        this.buildChimney((Chimney)((Object)blocks.cobblestone_chimney.get()), (TagKey<Item>)Tags.Items.COBBLESTONE, 8, output);
        this.buildChimney((Chimney)((Object)blocks.stone_chimney.get()), (TagKey<Item>)Tags.Items.STONE, 8, output);
        this.buildNarrowChimney((Chimney)((Object)blocks.small_brick_chimney.get()), ModItemTags.SMALL_BRICKS, 8, output);
        this.buildChimney((Chimney)((Object)blocks.large_brick_chimney.get()), ModItemTags.LARGE_BRICKS, 8, output);
        this.buildNarrowChimney((Chimney)((Object)blocks.metal_chimney.get()), (TagKey<Item>)Tags.Items.INGOTS, 8, output);
        this.buildChimney((Chimney)((Object)blocks.glass_chimney.get()), (TagKey<Item>)Tags.Items.GLASS, 8, output);
        this.buildVent((Vent)((Object)blocks.stone_vent.get()), (Chimney)((Object)blocks.stone_chimney.get()), output);
        this.buildVent((Vent)((Object)blocks.metal_vent.get()), (Chimney)((Object)blocks.metal_chimney.get()), output);
        this.buildPump((Pump)((Object)blocks.stone_pump.get()), (Vent)((Object)blocks.stone_vent.get()), output);
        this.buildPump((Pump)((Object)blocks.metal_pump.get()), (Vent)((Object)blocks.metal_vent.get()), output);
        this.buildPipe((Pipe)((Object)blocks.pipe.get()), (TagKey<Item>)Tags.Items.INGOTS_IRON, 8, output);
        this.buildPaintbrush((Paintbrush)((Object)mod.items.wooden_paintbrush.get()), (TagKey<Item>)Tags.Items.CROPS_WHEAT, output);
    }
}

