/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.recipes;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.codecs.recipes.ItemStackCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class IngredientCodec {
    public static final Codec<Ingredient> CODEC = Codec.PASSTHROUGH.comapFlatMap(IngredientCodec::decodeIngredient, IngredientCodec::encodeIngredient);
    public static final Codec<Ingredient> NETWORK_CODEC = ItemStackCodec.NETWORK_CODEC.listOf().xmap(IngredientCodec::decodeIngredient, IngredientCodec::encodeIngredientToNetwork);

    private static DataResult<Ingredient> decodeIngredient(Dynamic<?> dynamic) {
        Object object = dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue();
        if (object instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)object;
            return DataResult.success((Object)Ingredient.m_43917_((JsonElement)jsonElement));
        }
        return DataResult.error((String)"Value was not an instance of JsonElement");
    }

    private static Dynamic<JsonElement> encodeIngredient(Ingredient ingredient) {
        return new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)ingredient.m_43942_()).convert((DynamicOps)JsonOps.COMPRESSED);
    }

    private static Ingredient decodeIngredient(List<ItemStack> stacks) {
        return Ingredient.m_43921_(stacks.stream());
    }

    private static List<ItemStack> encodeIngredientToNetwork(Ingredient ingredient) {
        return Arrays.stream(ingredient.m_43908_()).collect(Collectors.toList());
    }
}

