/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import com.mojang.math.Vector3d;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarLockBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.PartLicensePlateHolder;
import de.maxhenkel.car.items.ItemLicensePlate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class EntityCarLicensePlateBase
extends EntityCarLockBase {
    private static final EntityDataAccessor<String> LICENSE_PLATE = SynchedEntityData.m_135353_(EntityCarLicensePlateBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EntityCarLicensePlateBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LICENSE_PLATE, (Object)"");
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        String text;
        ItemStack stack;
        if (player.m_6144_() && !this.isLocked() && this.hasLicensePlateHolder() && (stack = player.m_21120_(hand)).m_41720_() instanceof ItemLicensePlate && !(text = ItemLicensePlate.getText(stack)).isEmpty()) {
            ItemUtils.decrItemStack(stack, player);
            player.m_21008_(hand, stack);
            this.setLicensePlate(text);
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }

    public boolean hasLicensePlateHolder() {
        if (!(this instanceof EntityGenericCar)) {
            return false;
        }
        EntityGenericCar car = (EntityGenericCar)this;
        return car.getPartByClass(PartLicensePlateHolder.class) != null;
    }

    public String getLicensePlate() {
        return (String)this.f_19804_.m_135370_(LICENSE_PLATE);
    }

    public void setLicensePlate(String plate) {
        this.f_19804_.m_135381_(LICENSE_PLATE, (Object)plate);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("license_plate", this.getLicensePlate());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLicensePlate(compound.m_128461_("license_plate"));
    }

    public abstract Vector3d getLicensePlateOffset();
}

